/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.image.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.VerticalResizePanel;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ImageConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.image.ui.CurrentPageImageSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.widget.PageSelector;
import org.xwiki.gwt.wysiwyg.client.widget.SpaceSelector;
import org.xwiki.gwt.wysiwyg.client.widget.WikiSelector;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractSelectorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagesExplorerWizardStep
extends AbstractSelectorWizardStep<EntityLink<ImageConfig>>
implements ChangeHandler,
SourcesNavigationEvents {
    private static final String STYLE_LOADING = "loading";
    private WikiSelector wikiSelector;
    private SpaceSelector spaceSelector;
    private PageSelector pageSelector;
    private boolean displayWikiSelector;
    private final VerticalResizePanel mainPanel = new VerticalResizePanel();
    private CurrentPageImageSelectorWizardStep pageWizardStep;
    private final WikiServiceAsync wikiService;

    public ImagesExplorerWizardStep(boolean displayWikiSelector, WikiServiceAsync wikiService) {
        this.wikiService = wikiService;
        Label helpLabel = new Label(Strings.INSTANCE.imageSelectImageLocationHelpLabel());
        helpLabel.addStyleName("xHelpLabel");
        this.mainPanel.add((Widget)helpLabel);
        this.mainPanel.addStyleName("xImagesExplorer");
        this.displayWikiSelector = displayWikiSelector;
        this.mainPanel.add((Widget)this.getSelectorsPanel());
        this.pageWizardStep = new CurrentPageImageSelectorWizardStep(wikiService, true);
        this.mainPanel.add(this.pageWizardStep.display());
        this.mainPanel.setExpandingWidget(this.pageWizardStep.display(), true);
    }

    private Panel getSelectorsPanel() {
        FlowPanel selectorsPanel = new FlowPanel();
        if (this.displayWikiSelector) {
            this.wikiSelector = new WikiSelector(this.wikiService);
            this.wikiSelector.addChangeHandler(this);
            selectorsPanel.add((Widget)this.wikiSelector);
        }
        this.spaceSelector = new SpaceSelector(this.wikiService);
        this.spaceSelector.addChangeHandler(this);
        selectorsPanel.add((Widget)this.spaceSelector);
        this.pageSelector = new PageSelector(this.wikiService);
        selectorsPanel.add((Widget)this.pageSelector);
        Button updateImagesListButton = new Button(Strings.INSTANCE.imageUpdateListButton());
        updateImagesListButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EntityReference imageReferenceTemplate = new EntityReference();
                imageReferenceTemplate.setType(EntityReference.EntityType.IMAGE);
                imageReferenceTemplate.setWikiName(ImagesExplorerWizardStep.this.displayWikiSelector ? ImagesExplorerWizardStep.this.wikiSelector.getSelectedWiki() : ((EntityLink)ImagesExplorerWizardStep.this.getData()).getOrigin().getWikiName());
                imageReferenceTemplate.setSpaceName(ImagesExplorerWizardStep.this.spaceSelector.getSelectedSpace());
                imageReferenceTemplate.setPageName(ImagesExplorerWizardStep.this.pageSelector.getSelectedPage());
                ImagesExplorerWizardStep.this.initCurrentPage(imageReferenceTemplate, null);
            }
        });
        selectorsPanel.add((Widget)updateImagesListButton);
        selectorsPanel.addStyleName("xPageChooser");
        return selectorsPanel;
    }

    public void setSelection(final EntityReference imageReference, final AsyncCallback<?> cb) {
        if (this.displayWikiSelector) {
            this.wikiService.isMultiWiki(new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                    if (cb != null) {
                        cb.onFailure(caught);
                    }
                }

                public void onSuccess(Boolean result) {
                    if (result.booleanValue()) {
                        ImagesExplorerWizardStep.this.setWikiSelection(imageReference, cb);
                    } else {
                        ImagesExplorerWizardStep.this.setSpaceSelection(imageReference, cb);
                    }
                }
            });
        } else {
            this.setSpaceSelection(imageReference, cb);
        }
    }

    private void setWikiSelection(final EntityReference imageReference, final AsyncCallback<?> cb) {
        this.wikiSelector.refreshList(imageReference.getWikiName(), new AsyncCallback<List<String>>(){

            public void onSuccess(List<String> result) {
                ImagesExplorerWizardStep.this.setSpaceSelection(imageReference, cb);
            }

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                }
            }
        });
    }

    private void setSpaceSelection(final EntityReference imageReference, final AsyncCallback<?> cb) {
        this.spaceSelector.setWiki(this.displayWikiSelector ? imageReference.getWikiName() : ((EntityLink)this.getData()).getOrigin().getWikiName());
        this.spaceSelector.refreshList(imageReference.getSpaceName(), new AsyncCallback<List<String>>(){

            public void onSuccess(List<String> result) {
                ImagesExplorerWizardStep.this.setPageSelection(imageReference, cb);
            }

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                }
            }
        });
    }

    private void setPageSelection(final EntityReference imageReference, final AsyncCallback<?> cb) {
        this.pageSelector.setWiki(this.displayWikiSelector ? imageReference.getWikiName() : ((EntityLink)this.getData()).getOrigin().getWikiName());
        this.pageSelector.setSpace(imageReference.getSpaceName());
        this.pageSelector.refreshList(imageReference.getPageName(), new AsyncCallback<List<String>>(){

            public void onSuccess(List<String> result) {
                ImagesExplorerWizardStep.this.initCurrentPage(imageReference, cb);
            }

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                }
            }
        });
    }

    public void onChange(ChangeEvent event) {
        if (event.getSource() == this.wikiSelector) {
            this.spaceSelector.setWiki(this.wikiSelector.getSelectedWiki());
            this.spaceSelector.refreshList(this.spaceSelector.getSelectedSpace(), new AsyncCallback<List<String>>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(List<String> result) {
                    ImagesExplorerWizardStep.this.pageSelector.setWiki(ImagesExplorerWizardStep.this.wikiSelector.getSelectedWiki());
                    ImagesExplorerWizardStep.this.pageSelector.setSpace(ImagesExplorerWizardStep.this.spaceSelector.getSelectedSpace());
                    ImagesExplorerWizardStep.this.pageSelector.refreshList(ImagesExplorerWizardStep.this.pageSelector.getSelectedPage());
                }
            });
        } else if (event.getSource() == this.spaceSelector) {
            this.pageSelector.setWiki(this.displayWikiSelector ? this.wikiSelector.getSelectedWiki() : ((EntityLink)this.getData()).getOrigin().getWikiName());
            this.pageSelector.setSpace(this.spaceSelector.getSelectedSpace());
            this.pageSelector.refreshList(this.pageSelector.getSelectedPage());
        }
    }

    protected void initCurrentPage(EntityReference imageReference, final AsyncCallback<?> cb) {
        this.mainPanel.addStyleName(STYLE_LOADING);
        ((EntityLink)this.getData()).setDestination(imageReference);
        this.pageWizardStep.init(this.getData(), new AsyncCallback<Object>(){

            public void onSuccess(Object result) {
                ImagesExplorerWizardStep.this.onCurrenPageInitialization();
                if (cb != null) {
                    cb.onSuccess(null);
                }
            }

            public void onFailure(Throwable caught) {
                if (cb != null) {
                    cb.onFailure(caught);
                } else {
                    ImagesExplorerWizardStep.this.showCurrentPageInitializationError();
                }
            }
        });
    }

    private void showCurrentPageInitializationError() {
        this.mainPanel.removeStyleName(STYLE_LOADING);
        Label error = new Label(Strings.INSTANCE.linkErrorLoadingData());
        error.addStyleName("errormessage");
        this.mainPanel.remove(this.pageWizardStep.display());
        this.mainPanel.add((Widget)error);
    }

    private void onCurrenPageInitialization() {
        if (this.mainPanel.getWidgetIndex(this.pageWizardStep.display()) < 0) {
            this.mainPanel.remove(this.mainPanel.getWidgetCount() - 1);
            this.mainPanel.add(this.pageWizardStep.display());
        }
        this.mainPanel.removeStyleName(STYLE_LOADING);
    }

    public Widget display() {
        return this.mainPanel;
    }

    public String getNextStep() {
        return this.pageWizardStep.getNextStep();
    }

    public String getStepTitle() {
        return Strings.INSTANCE.imageSelectImageTitle();
    }

    @Override
    protected void initializeSelection(AsyncCallback<?> cb) {
        if (!StringUtils.isEmpty((String)((ImageConfig)((EntityLink)this.getData()).getData()).getReference())) {
            this.setSelection(((EntityLink)this.getData()).getDestination(), cb);
        } else if (this.pageSelector.getSelectedPage() == null) {
            this.setSelection(((EntityLink)this.getData()).getOrigin(), cb);
        } else {
            this.initCurrentPage(((EntityLink)this.pageWizardStep.getData()).getDestination(), cb);
        }
    }

    public void onCancel() {
        this.pageWizardStep.onCancel();
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        this.pageWizardStep.onSubmit(async);
    }

    public void addNavigationListener(NavigationListener listener) {
        this.pageWizardStep.addNavigationListener(listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.pageWizardStep.removeNavigationListener(listener);
    }

    @Override
    public void setActive() {
        if (this.displayWikiSelector) {
            this.wikiSelector.setFocus(true);
        } else {
            this.spaceSelector.setFocus(true);
        }
    }

    @Override
    public Object getResult() {
        return this.pageWizardStep.getResult();
    }
}

