/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.wysiwyg.client.plugin.Plugin;
import org.xwiki.gwt.wysiwyg.client.plugin.PluginFactory;
import org.xwiki.gwt.wysiwyg.client.plugin.PluginFactoryManager;
import org.xwiki.gwt.wysiwyg.client.plugin.PluginManager;
import org.xwiki.gwt.wysiwyg.client.plugin.UIExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginManager
implements PluginManager {
    private final Map<String, Plugin> loadedPlugins;
    private final Map<String, Map<String, UIExtension>> uiExtensions;
    private final RichTextArea textArea;
    private final Config config;
    private PluginFactoryManager pfm;

    public DefaultPluginManager(RichTextArea textArea, Config config) {
        this.textArea = textArea;
        this.config = config;
        this.loadedPlugins = new HashMap<String, Plugin>();
        this.uiExtensions = new HashMap<String, Map<String, UIExtension>>();
    }

    @Override
    public PluginFactoryManager getPluginFactoryManager() {
        return this.pfm;
    }

    @Override
    public void setPluginFactoryManager(PluginFactoryManager pfm) {
        this.pfm = pfm;
    }

    @Override
    public void load(String pluginName) {
        if (this.loadedPlugins.containsKey(pluginName)) {
            return;
        }
        PluginFactory factory = this.pfm.getPluginFactory(pluginName);
        if (factory == null) {
            return;
        }
        Plugin plugin = factory.newInstance();
        this.loadedPlugins.put(pluginName, plugin);
        plugin.init(this.textArea, this.config);
        UIExtension[] newUIExtensions = plugin.getUIExtensions();
        for (int i = 0; i < newUIExtensions.length; ++i) {
            UIExtension newUIExtension = newUIExtensions[i];
            String[] newFeatures = newUIExtension.getFeatures();
            Map<String, UIExtension> oldUIExtensions = this.getUIExtensions(newUIExtension.getRole());
            for (int j = 0; j < newFeatures.length; ++j) {
                oldUIExtensions.put(newFeatures[j], newUIExtension);
            }
        }
    }

    @Override
    public void unload(String pluginName) {
        Plugin plugin = this.loadedPlugins.remove(pluginName);
        if (plugin != null) {
            UIExtension[] pluginUIExtensions = plugin.getUIExtensions();
            for (int i = 0; i < pluginUIExtensions.length; ++i) {
                UIExtension pluginUIExtension = pluginUIExtensions[i];
                String[] pluginFeatures = pluginUIExtension.getFeatures();
                Map<String, UIExtension> loadedUIExtensions = this.getUIExtensions(pluginUIExtension.getRole());
                for (int j = 0; j < pluginFeatures.length; ++j) {
                    if (!pluginUIExtension.equals(loadedUIExtensions.get(pluginFeatures[j]))) continue;
                    loadedUIExtensions.remove(pluginFeatures[j]);
                }
            }
            plugin.destroy();
        }
    }

    @Override
    public void unloadAll() {
        HashSet<String> pluginNames = new HashSet<String>(this.loadedPlugins.keySet());
        for (String pluginName : pluginNames) {
            this.unload(pluginName);
        }
        pluginNames.clear();
    }

    @Override
    public UIExtension getUIExtension(String role, String feature) {
        return this.getUIExtensions(role).get(feature);
    }

    private Map<String, UIExtension> getUIExtensions(String role) {
        Map<String, UIExtension> roleUIExtensions = this.uiExtensions.get(role);
        if (roleUIExtensions == null) {
            roleUIExtensions = new HashMap<String, UIExtension>();
            this.uiExtensions.put(role, roleUIExtensions);
        }
        return roleUIExtensions;
    }
}

