/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.line;

import com.google.gwt.dom.client.BRElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.ParagraphElement;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import java.util.ArrayList;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.Event;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.dom.client.Style;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;

public class LinePlugin
extends AbstractPlugin
implements KeyDownHandler,
KeyUpHandler,
KeyPressHandler,
CommandListener {
    public static final Command SUBMIT = new Command("submit");
    public static final Command RESET = new Command("reset");
    public static final String SPACER = "spacer";
    public static final String LINE_BREAK = "lineBreak";
    public static final String CLASS_NAME = "class";
    public static final String BR = "br";
    public static final String LI = "li";
    public static final String TD = "td";
    public static final String TH = "th";
    protected final DOMUtils domUtils = DOMUtils.getInstance();
    private boolean ignoreNextKeyPress;
    private boolean cancelNextKeyPress;

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.saveRegistration(this.getTextArea().addKeyDownHandler((KeyDownHandler)this));
        this.saveRegistration(this.getTextArea().addKeyUpHandler((KeyUpHandler)this));
        this.saveRegistration(this.getTextArea().addKeyPressHandler((KeyPressHandler)this));
        this.getTextArea().getCommandManager().addCommandListener((CommandListener)this);
        this.onReset();
    }

    public void destroy() {
        this.getTextArea().getCommandManager().removeCommandListener((CommandListener)this);
        super.destroy();
    }

    public void onKeyDown(KeyDownEvent event) {
        if (event.getSource() == this.getTextArea()) {
            this.ignoreNextKeyPress = true;
            this.handleRepeatableKey((Event)event.getNativeEvent());
            this.cancelNextKeyPress = ((Event)event.getNativeEvent()).isCancelled();
        }
    }

    public void onKeyPress(KeyPressEvent event) {
        if (event.getSource() == this.getTextArea()) {
            if (!this.ignoreNextKeyPress) {
                this.handleRepeatableKey((Event)event.getNativeEvent());
            } else if (this.cancelNextKeyPress) {
                ((Event)event.getNativeEvent()).xPreventDefault();
            }
            this.ignoreNextKeyPress = false;
            this.cancelNextKeyPress = false;
        }
    }

    public void onKeyUp(KeyUpEvent event) {
        this.ignoreNextKeyPress = false;
        this.cancelNextKeyPress = false;
    }

    protected void handleRepeatableKey(Event event) {
        switch (event.getKeyCode()) {
            case 13: {
                this.onEnter(event);
                break;
            }
            case 8: {
                this.onBackspace(event);
                break;
            }
        }
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        if (SUBMIT.equals((Object)command)) {
            this.markSpacers();
        }
        return false;
    }

    public void onCommand(CommandManager sender, Command command, String param) {
        if (SUBMIT.equals((Object)command)) {
            this.unMarkSpacers();
        } else if (RESET.equals((Object)command)) {
            this.onReset();
        }
    }

    protected void markSpacers() {
        Document document = this.getTextArea().getDocument();
        NodeList brs = document.getBody().getElementsByTagName(BR);
        for (int i = 0; i < brs.getLength(); ++i) {
            org.xwiki.gwt.dom.client.Element br = (org.xwiki.gwt.dom.client.Element)((Element)brs.getItem(i)).cast();
            if (LINE_BREAK.equals(br.getClassName())) continue;
            Node container = this.domUtils.getNearestBlockContainer((Node)br);
            Node leaf = this.domUtils.getNextLeaf((Node)br);
            boolean emptyLine = true;
            while (leaf != null && container == this.domUtils.getNearestBlockContainer(leaf)) {
                if (this.needsSpace(leaf)) {
                    emptyLine = false;
                    break;
                }
                leaf = this.domUtils.getNextLeaf(leaf);
            }
            if (emptyLine) {
                br.setClassName(SPACER);
                continue;
            }
            br.removeAttribute(CLASS_NAME);
        }
    }

    protected void unMarkSpacers() {
        Document document = this.getTextArea().getDocument();
        NodeList brs = document.getBody().getElementsByTagName(BR);
        for (int i = 0; i < brs.getLength(); ++i) {
            org.xwiki.gwt.dom.client.Element br = (org.xwiki.gwt.dom.client.Element)brs.getItem(i);
            if (!SPACER.equals(br.getClassName())) continue;
            br.removeAttribute(CLASS_NAME);
        }
    }

    protected boolean needsSpace(Node leaf) {
        switch (leaf.getNodeType()) {
            case 3: {
                return leaf.getNodeValue().length() > 0;
            }
            case 1: {
                org.xwiki.gwt.dom.client.Element element = org.xwiki.gwt.dom.client.Element.as((Node)leaf);
                return BR.equalsIgnoreCase(element.getTagName()) || element.getOffsetHeight() > 0 || element.getOffsetWidth() > 0;
            }
        }
        return false;
    }

    protected void markInitialLineBreaks() {
        Document document = this.getTextArea().getDocument();
        NodeList brs = document.getBody().getElementsByTagName(BR);
        for (int i = 0; i < brs.getLength(); ++i) {
            org.xwiki.gwt.dom.client.Element br = (org.xwiki.gwt.dom.client.Element)brs.getItem(i);
            if (br.hasAttribute("_moz_dirty") || SPACER.equals(br.getClassName())) continue;
            br.setClassName(LINE_BREAK);
        }
    }

    protected void replaceEmptyLinesWithParagraphs() {
        Document document = this.getTextArea().getDocument();
        NodeList divs = document.getBody().getElementsByTagName("div");
        ArrayList<org.xwiki.gwt.dom.client.Element> emptyLines = new ArrayList<org.xwiki.gwt.dom.client.Element>();
        for (int i = 0; i < divs.getLength(); ++i) {
            org.xwiki.gwt.dom.client.Element element = (org.xwiki.gwt.dom.client.Element)((Element)divs.getItem(i)).cast();
            if (!element.hasClassName("wikimodel-emptyline")) continue;
            emptyLines.add(element);
        }
        for (Node node : emptyLines) {
            node.getParentNode().replaceChild((Node)document.createPElement(), node);
        }
    }

    protected void onEnter(Event event) {
        String containerName;
        Selection selection = this.getTextArea().getDocument().getSelection();
        if (!selection.isCollapsed()) {
            this.getTextArea().getDocument().execCommand(Command.DELETE.toString(), null);
        }
        Range caret = selection.getRangeAt(0);
        Node container = null;
        if (!event.getCtrlKey() && !event.getMetaKey()) {
            container = this.domUtils.getFirstAncestor(caret.getStartContainer(), new String[]{LI});
        }
        if (container == null) {
            container = this.domUtils.getNearestBlockContainer(caret.getStartContainer());
        }
        if (LI.equals(containerName = container.getNodeName().toLowerCase())) {
            return;
        }
        if (TD.equals(containerName) || TH.equals(containerName)) {
            this.insertLineBreak(container, caret);
        } else {
            this.onEnterParagraph(container, caret, event);
        }
        event.xPreventDefault();
        caret.collapse(true);
        selection.removeAllRanges();
        selection.addRange(caret);
    }

    protected void onEnterParagraph(Node container, Range caret, Event event) {
        if (event.getShiftKey()) {
            this.insertLineBreak(container, caret);
        } else if (this.isAtStart(container, caret)) {
            this.insertEmptyLine(container, caret);
        } else {
            if (!this.isAfterLineBreak(container, caret)) {
                this.insertLineBreak(container, caret);
            }
            this.splitLine(container, caret);
        }
    }

    protected boolean isAtStart(Node container, Range caret) {
        if (!container.hasChildNodes()) {
            return true;
        }
        if (caret.getStartOffset() > 0) {
            return false;
        }
        return this.domUtils.getFirstLeaf(container) == this.domUtils.getFirstLeaf(caret.getStartContainer());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isAfterLineBreak(Node container, Range caret) {
        Node leaf;
        if (caret.getStartOffset() > 0) {
            if (caret.getStartContainer().getNodeType() != 1) return false;
            leaf = caret.getStartContainer().getChildNodes().getItem(caret.getStartOffset() - 1);
            leaf = this.domUtils.getLastLeaf(leaf);
        } else {
            leaf = this.domUtils.getPreviousLeaf(caret.getStartContainer());
        }
        if (!this.isLineBreak(leaf)) return false;
        if (container != this.domUtils.getNearestBlockContainer(leaf)) return false;
        return true;
    }

    protected boolean isLineBreak(Node node) {
        return node != null && BR.equalsIgnoreCase(node.getNodeName());
    }

    protected void adjustLineBreak(Node container, Node br) {
        Node anchor = this.domUtils.getFirstAncestor(br, new String[]{"a"});
        if (anchor != null) {
            Node firstLeaf = this.domUtils.getFirstLeaf(anchor);
            Node leaf = br;
            boolean startsWithLineBreak = true;
            while (leaf != firstLeaf) {
                if (!this.needsSpace(leaf = this.domUtils.getPreviousLeaf(leaf))) continue;
                startsWithLineBreak = false;
                break;
            }
            if (startsWithLineBreak) {
                anchor.getParentNode().insertBefore(br, anchor);
            } else {
                Node lastLeaf = this.domUtils.getLastLeaf(anchor);
                leaf = br;
                boolean endsWithLineBreak = true;
                while (leaf != lastLeaf) {
                    if (!this.needsSpace(leaf = this.domUtils.getNextLeaf(leaf))) continue;
                    endsWithLineBreak = false;
                    break;
                }
                if (endsWithLineBreak) {
                    this.domUtils.insertAfter(br, anchor);
                }
            }
        }
    }

    protected void insertLineBreak(Node container, Range caret) {
        BRElement lineBreak = this.getTextArea().getDocument().createBRElement();
        switch (caret.getStartContainer().getNodeType()) {
            case 4: 
            case 8: {
                this.domUtils.insertAfter((Node)lineBreak, caret.getStartContainer());
                break;
            }
            case 3: {
                Node refNode = this.domUtils.splitNode(caret.getStartContainer(), caret.getStartOffset());
                refNode.getParentNode().insertBefore((Node)lineBreak, refNode);
                break;
            }
            case 1: {
                this.domUtils.insertAt(caret.getStartContainer(), (Node)lineBreak, caret.getStartOffset());
                break;
            }
        }
        Node start = lineBreak.getNextSibling();
        if (start == null || start.getNodeType() != 3) {
            start = this.getTextArea().getDocument().createTextNode("");
            this.domUtils.insertAfter(start, (Node)lineBreak);
        }
        caret.setStart(start, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void splitLine(Node container, Range caret) {
        Node start;
        Node br;
        if (caret.getStartOffset() > 0) {
            if (caret.getStartContainer().getNodeType() != 1) return;
            br = caret.getStartContainer().getChildNodes().getItem(caret.getStartOffset() - 1);
            br = this.domUtils.getLastLeaf(br);
        } else {
            br = this.domUtils.getPreviousLeaf(caret.getStartContainer());
        }
        this.adjustLineBreak(container, br);
        ParagraphElement paragraph = this.getTextArea().getDocument().createPElement();
        if (this.domUtils.isFlowContainer(container)) {
            start = this.splitContentAndWrap(container, br, (Node)paragraph);
        } else {
            start = this.splitAndReplace(container, br, (Node)paragraph);
            this.copyLineStyle(org.xwiki.gwt.dom.client.Element.as((Node)container), org.xwiki.gwt.dom.client.Element.as((Node)paragraph));
        }
        br.getParentNode().removeChild(br);
        org.xwiki.gwt.dom.client.Element.as((Node)container).ensureEditable();
        org.xwiki.gwt.dom.client.Element.as((Node)paragraph).ensureEditable();
        if (!start.hasChildNodes()) {
            start.appendChild((Node)this.getTextArea().getDocument().createTextNode(""));
        }
        if (start.getFirstChild().getNodeType() == 3) {
            start = start.getFirstChild();
        }
        caret.setStart(start, 0);
    }

    protected void insertEmptyLine(Node container, Range caret) {
        Document document = this.getTextArea().getDocument();
        org.xwiki.gwt.dom.client.Element emptyLine = (org.xwiki.gwt.dom.client.Element)document.createPElement().cast();
        if (this.domUtils.isFlowContainer(container)) {
            this.domUtils.insertAt(container, (Node)emptyLine, 0);
            caret.setStartAfter((Node)emptyLine);
        } else {
            container.getParentNode().insertBefore((Node)emptyLine, container);
        }
        this.domUtils.ensureBlockIsEditable(emptyLine);
    }

    protected void onBackspace(Event event) {
        Selection selection = this.getTextArea().getDocument().getSelection();
        if (!selection.isCollapsed()) {
            return;
        }
        Range caret = selection.getRangeAt(0);
        Node container = this.domUtils.getNearestBlockContainer(caret.getStartContainer());
        if (this.domUtils.isBlockLevelInlineContainer(container) && this.isAtStart(container, caret) && this.isEmptyLine(container.getPreviousSibling())) {
            event.xPreventDefault();
            container.getParentNode().removeChild(container.getPreviousSibling());
        }
    }

    protected boolean isEmptyLine(Node node) {
        if (node == null || !"p".equalsIgnoreCase(node.getNodeName())) {
            return false;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if ((child.getNodeType() != 1 || ((org.xwiki.gwt.dom.client.Element)child).getOffsetWidth() <= 0) && StringUtils.isEmpty((String)child.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    protected void onReset() {
        this.markInitialLineBreaks();
        this.replaceEmptyLinesWithParagraphs();
        org.xwiki.gwt.dom.client.Element.as((Node)this.getTextArea().getDocument().getBody()).ensureEditable();
    }

    private Node splitAndReplace(Node container, Node child, Node replacement) {
        Node start = this.domUtils.splitNode(container.getParentNode(), child.getParentNode(), this.domUtils.getNodeIndex(child));
        if (start == container.getNextSibling()) {
            start = replacement;
        }
        replacement.appendChild((Node)org.xwiki.gwt.dom.client.Element.as((Node)container.getNextSibling()).extractContents());
        container.getParentNode().replaceChild(replacement, container.getNextSibling());
        return start;
    }

    private Node splitContentAndWrap(Node container, Node descendant, Node wrapper) {
        Node start = wrapper;
        Node child = this.domUtils.getChild(container, descendant);
        if (child != descendant) {
            start = this.domUtils.splitNode(container, descendant.getParentNode(), this.domUtils.getNodeIndex(descendant));
        }
        this.domUtils.insertAfter(wrapper, child);
        child = wrapper.getNextSibling();
        while (child != null && this.domUtils.isInline(child)) {
            wrapper.appendChild(child);
            child = wrapper.getNextSibling();
        }
        return start;
    }

    protected void copyLineStyle(org.xwiki.gwt.dom.client.Element sourceLine, org.xwiki.gwt.dom.client.Element destinationLine) {
        destinationLine.getStyle().setProperty(Style.TEXT_ALIGN.getJSName(), sourceLine.getStyle().getProperty(Style.TEXT_ALIGN.getJSName()));
    }
}

