/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Node;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.user.client.EscapeUtils;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.rta.cmd.internal.AbstractInsertElementExecutable;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkConfigDOMWriter
implements AbstractInsertElementExecutable.ConfigDOMWriter<LinkConfig, AnchorElement> {
    private static final Map<LinkConfig.LinkType, String> CLASS_NAME_MAPPING = new HashMap<LinkConfig.LinkType, String>();
    private static final String TARGET_BLANK = "__blank";

    public void write(LinkConfig config, AnchorElement anchor) {
        this.updateMetaData(anchor, config.getReference(), config.getType());
        anchor.setHref(config.getUrl());
        this.updateAttribute(anchor, "title", config.getTooltip());
        if (config.isOpenInNewWindow()) {
            anchor.setRel(TARGET_BLANK);
        } else if (TARGET_BLANK.equalsIgnoreCase(anchor.getRel())) {
            anchor.removeAttribute("rel");
        }
        if (!anchor.getInnerHTML().equals(config.getLabel())) {
            Element.as((Node)anchor).xSetInnerHTML(config.getLabel());
        }
    }

    private void updateMetaData(AnchorElement anchor, String reference, LinkConfig.LinkType linkType) {
        Document document = (Document)anchor.getOwnerDocument();
        DocumentFragment metaData = document.createDocumentFragment();
        metaData.appendChild(document.createComment("startwikilink:" + EscapeUtils.escapeComment((String)reference)));
        metaData.appendChild((Node)document.createSpanElement());
        if (CLASS_NAME_MAPPING.containsKey((Object)linkType)) {
            Element.as((Node)metaData.getChild(1)).setClassName(CLASS_NAME_MAPPING.get((Object)linkType));
        }
        metaData.getChild(1).appendChild((Node)document.createTextNode("org.xwiki.gwt.dom.client.Element#placeholder"));
        metaData.appendChild(document.createComment("stopwikilink"));
        Element.as((Node)anchor).setMetaData(metaData);
    }

    private void updateAttribute(AnchorElement anchor, String name, String value) {
        if (StringUtils.isEmpty((String)value)) {
            anchor.removeAttribute(name);
        } else {
            anchor.setAttribute(name, value);
        }
    }

    static {
        CLASS_NAME_MAPPING.put(LinkConfig.LinkType.WIKIPAGE, "wikilink");
        CLASS_NAME_MAPPING.put(LinkConfig.LinkType.NEW_WIKIPAGE, "wikicreatelink");
        CLASS_NAME_MAPPING.put(LinkConfig.LinkType.EXTERNAL, "wikiexternallink");
        CLASS_NAME_MAPPING.put(LinkConfig.LinkType.ATTACHMENT, CLASS_NAME_MAPPING.get((Object)LinkConfig.LinkType.EXTERNAL));
        CLASS_NAME_MAPPING.put(LinkConfig.LinkType.EMAIL, CLASS_NAME_MAPPING.get((Object)LinkConfig.LinkType.EXTERNAL));
    }
}

