/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link;

import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.InnerHTMLListener;
import org.xwiki.gwt.dom.client.Text;

public class LinkMetaDataExtractor
implements InnerHTMLListener {
    public void onInnerHTMLChange(Element parent) {
        NodeList anchors = parent.getElementsByTagName("a");
        for (int i = 0; i < anchors.getLength(); ++i) {
            Element anchor = (Element)anchors.getItem(i);
            this.processElement(anchor);
        }
    }

    private void processElement(Element anchor) {
        Element parentNode = (Element)anchor.getParentElement().cast();
        boolean foundWikiLink = parentNode != null && parentNode.getNodeName().equalsIgnoreCase("span");
        String spanClass = parentNode.getClassName();
        boolean bl = spanClass.contains("wikilink") || spanClass.contains("wikicreatelink") || spanClass.contains("wikiexternallink");
        Node previousSibling = null;
        Node nextSibling = null;
        if (foundWikiLink &= bl) {
            previousSibling = parentNode.getPreviousSibling();
            foundWikiLink &= previousSibling != null && previousSibling.getNodeType() == 8 && previousSibling.getNodeValue().startsWith("startwikilink");
            nextSibling = parentNode.getNextSibling();
            foundWikiLink &= nextSibling != null && nextSibling.getNodeType() == 8 && nextSibling.getNodeValue().startsWith("stopwikilink");
        }
        if (!foundWikiLink) {
            return;
        }
        DocumentFragment metaFragment = ((Document)anchor.getOwnerDocument()).createDocumentFragment();
        metaFragment.appendChild(previousSibling);
        Text placeholder = (Text)((Document)anchor.getOwnerDocument()).createTextNode("org.xwiki.gwt.dom.client.Element#placeholder");
        parentNode.replaceChild((Node)placeholder, (Node)anchor);
        parentNode.getParentElement().replaceChild((Node)anchor, (Node)parentNode);
        metaFragment.appendChild((Node)parentNode);
        metaFragment.appendChild(nextSibling);
        anchor.setMetaData(metaFragment);
    }
}

