/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.user.client.FocusCommand;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkConfigWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExternalLinkWizardStep
extends LinkConfigWizardStep {
    private final TextBox urlTextBox = new TextBox();
    private final Label urlErrorLabel = new Label();
    private FlowPanel mainPanel;

    public AbstractExternalLinkWizardStep(WikiServiceAsync wikiService) {
        super(wikiService);
        FlowPanel urlLabel = new FlowPanel();
        urlLabel.setStyleName("xInfoLabel");
        urlLabel.add((Widget)new InlineLabel(this.getURLLabel()));
        InlineLabel mandatoryLabel = new InlineLabel(Strings.INSTANCE.mandatory());
        mandatoryLabel.addStyleName("xMandatory");
        urlLabel.add((Widget)mandatoryLabel);
        Label helpUrlLabel = new Label(this.getURLHelpLabel());
        helpUrlLabel.setStyleName("xHelpLabel");
        this.urlErrorLabel.addStyleName("xErrorMsg");
        this.urlErrorLabel.setVisible(false);
        this.urlTextBox.setTitle(this.getURLTextBoxTooltip());
        this.urlTextBox.addKeyPressHandler((KeyPressHandler)this);
        this.getLabelTextBox().setTitle(this.getLabelTextBoxTooltip());
        this.mainPanel = new FlowPanel();
        this.mainPanel.removeStyleName("xLinkConfig");
        this.mainPanel.addStyleName("xLinkToUrl");
        FlowPanel urlPanel = new FlowPanel();
        urlPanel.addStyleName("url");
        urlPanel.add((Widget)urlLabel);
        urlPanel.add((Widget)helpUrlLabel);
        urlPanel.add((Widget)this.urlErrorLabel);
        urlPanel.add((Widget)this.urlTextBox);
        this.mainPanel.add((Widget)urlPanel);
        this.mainPanel.add((Widget)this.getMainPanel());
    }

    @Override
    public void init(Object data, final AsyncCallback<?> cb) {
        super.init(data, new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                AbstractExternalLinkWizardStep.this.urlTextBox.setText(AbstractExternalLinkWizardStep.this.getLinkConfig().getUrl() == null ? "" : AbstractExternalLinkWizardStep.this.getLinkConfig().getUrl());
                cb.onSuccess(null);
            }

            public void onFailure(Throwable caught) {
                cb.onFailure(caught);
            }
        });
    }

    @Override
    protected void setFocus() {
        if (this.getLabelErrorLabel().isVisible() && !this.urlErrorLabel.isVisible()) {
            DeferredCommand.addCommand((Command)new FocusCommand((Focusable)this.getLabelTextBox()));
        } else {
            DeferredCommand.addCommand((Command)new FocusCommand((Focusable)this.urlTextBox));
        }
    }

    @Override
    public Widget display() {
        return this.mainPanel;
    }

    @Override
    protected boolean validateForm() {
        boolean result = super.validateForm();
        if (this.urlTextBox.getText().trim().length() == 0) {
            this.displayURLError(this.getURLErrorMessage());
            result = false;
        }
        return result;
    }

    @Override
    protected void saveForm() {
        super.saveForm();
        String linkUri = this.buildURL();
        this.getLinkConfig().setUrl(linkUri);
        this.getLinkConfig().setReference(linkUri);
    }

    public TextBox getUrlTextBox() {
        return this.urlTextBox;
    }

    protected abstract String getURLLabel();

    protected abstract String getURLHelpLabel();

    protected abstract String getURLErrorMessage();

    protected abstract String buildURL();

    protected String getURLTextBoxTooltip() {
        return "";
    }

    @Override
    protected void hideErrors() {
        super.hideErrors();
        this.urlErrorLabel.setVisible(false);
        this.urlTextBox.removeStyleName("xErrorField");
    }

    protected void displayURLError(String errorMessage) {
        this.urlErrorLabel.setText(errorMessage);
        this.urlErrorLabel.setVisible(true);
        this.urlTextBox.addStyleName("xErrorField");
    }
}

