/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.link.ui;

import com.google.gwt.user.client.rpc.AsyncCallback;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.link.LinkConfig;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.AbstractExplorerWizardStep;
import org.xwiki.gwt.wysiwyg.client.plugin.link.ui.LinkWizard;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageExplorerWizardStep
extends AbstractExplorerWizardStep {
    public WikiPageExplorerWizardStep(WikiServiceAsync wikiService) {
        super(wikiService, true, false, false, 455, 280);
        this.setStepTitle(Strings.INSTANCE.linkSelectWikipageTitle());
        this.setHelpLabelText(Strings.INSTANCE.linkSelectWikipageHelpLabel());
    }

    public String getNextStep() {
        return StringUtils.isEmpty((String)((EntityLink)this.getData()).getDestination().getPageName()) ? LinkWizard.LinkWizardStep.WIKI_PAGE_CREATOR.toString() : LinkWizard.LinkWizardStep.WIKI_PAGE_CONFIG.toString();
    }

    public void onSubmit(final AsyncCallback<Boolean> async) {
        this.hideError();
        EntityReference pageReference = new EntityReference();
        pageReference.setType(((EntityLink)this.getData()).getDestination().getType());
        pageReference.setWikiName(this.getExplorer().getSelectedWiki());
        pageReference.setSpaceName(this.getExplorer().getSelectedSpace());
        pageReference.setPageName(this.getExplorer().getSelectedPage());
        if (this.getExplorer().isNewPageSelectedFromTreeNode()) {
            ((LinkConfig)((EntityLink)this.getData()).getData()).setType(LinkConfig.LinkType.NEW_WIKIPAGE);
            ((EntityLink)this.getData()).setDestination(pageReference);
            async.onSuccess((Object)true);
        } else if (!StringUtils.isEmpty((String)pageReference.getPageName())) {
            if (((EntityLink)this.getData()).getDestination().equals(pageReference)) {
                async.onSuccess((Object)true);
            } else {
                this.updateLinkConfig(pageReference, new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        async.onFailure(caught);
                    }

                    public void onSuccess(Boolean result) {
                        if (result.booleanValue()) {
                            LinkConfig.LinkType linkType = WikiPageExplorerWizardStep.this.getExplorer().isNewPage() ? LinkConfig.LinkType.NEW_WIKIPAGE : LinkConfig.LinkType.WIKIPAGE;
                            ((LinkConfig)((EntityLink)WikiPageExplorerWizardStep.this.getData()).getData()).setType(linkType);
                        }
                        async.onSuccess((Object)result);
                    }
                });
            }
        } else {
            this.displayError(Strings.INSTANCE.linkNoPageSelectedError());
            async.onSuccess((Object)false);
        }
    }
}

