/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.list;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.Event;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBehaviorAdjuster
implements KeyDownHandler,
KeyUpHandler,
KeyPressHandler,
CommandListener {
    protected static final String LIST_ITEM_TAG = "li";
    protected static final String UNORDERED_LIST_TAG = "ul";
    protected static final String ORDERED_LIST_TAG = "ol";
    protected static final Command RESET_COMMAND = new Command("reset");
    private RichTextArea textArea;

    protected void cleanUp(org.xwiki.gwt.dom.client.Element element) {
        NodeList orderedLists = element.getElementsByTagName(ORDERED_LIST_TAG);
        NodeList unorderedLists = element.getElementsByTagName(UNORDERED_LIST_TAG);
        this.cleanUpLists((NodeList<Element>)orderedLists);
        this.cleanUpLists((NodeList<Element>)unorderedLists);
    }

    protected void cleanUpLists(NodeList<Element> listElements) {
        for (int i = 0; i < listElements.getLength(); ++i) {
            org.xwiki.gwt.dom.client.Element listElement = (org.xwiki.gwt.dom.client.Element)listElements.getItem(i);
            if (listElement.getParentNode().getNodeName().equalsIgnoreCase(ORDERED_LIST_TAG) || listElement.getParentNode().getNodeName().equalsIgnoreCase(UNORDERED_LIST_TAG)) {
                this.wrapList(listElement);
            }
            if (!listElement.getParentNode().getNodeName().equalsIgnoreCase(LIST_ITEM_TAG) || listElement.getPreviousSibling() != null) continue;
            this.handleEmptyListItem((org.xwiki.gwt.dom.client.Element)listElement.getParentNode());
        }
    }

    protected void wrapList(org.xwiki.gwt.dom.client.Element listElement) {
        org.xwiki.gwt.dom.client.Element previousListItem = (org.xwiki.gwt.dom.client.Element)listElement.getPreviousSibling();
        if (previousListItem != null && previousListItem.getNodeName().equalsIgnoreCase(LIST_ITEM_TAG)) {
            previousListItem.appendChild((Node)listElement);
        } else {
            org.xwiki.gwt.dom.client.Element wrappingListItem = (org.xwiki.gwt.dom.client.Element)listElement.getOwnerDocument().createLIElement().cast();
            wrappingListItem.wrap((Node)listElement);
        }
    }

    protected void handleEmptyListItem(org.xwiki.gwt.dom.client.Element li) {
        DOMUtils.getInstance().insertAt((Node)li, (Node)li.getOwnerDocument().createBRElement(), 0);
    }

    protected void onDelete(org.xwiki.gwt.dom.client.Element li, Event event) {
        Range range = this.getTextArea().getDocument().getSelection().getRangeAt(0);
        if (!range.isCollapsed()) {
            return;
        }
        Node endContainer = range.getEndContainer();
        if (endContainer.getNodeType() == 3 && DOMUtils.getInstance().getLength(endContainer) != range.getEndOffset()) {
            return;
        }
        Node nextLeaf = DOMUtils.getInstance().getNextLeaf(range);
        if (nextLeaf == null) {
            event.xPreventDefault();
            return;
        }
        org.xwiki.gwt.dom.client.Element nextLeafAncestorLi = (org.xwiki.gwt.dom.client.Element)DOMUtils.getInstance().getFirstAncestor(nextLeaf, new String[]{LIST_ITEM_TAG});
        Node nextEmptyItemPlacehodlerLeaf = null;
        if (nextLeafAncestorLi == li && this.isEmptyListItemPlaceholder(nextLeaf)) {
            nextEmptyItemPlacehodlerLeaf = nextLeaf;
            nextLeaf = DOMUtils.getInstance().getNextLeaf(nextLeaf);
            if (nextLeaf == null) {
                event.xPreventDefault();
                return;
            }
            nextLeafAncestorLi = (org.xwiki.gwt.dom.client.Element)DOMUtils.getInstance().getFirstAncestor(nextLeaf, new String[]{LIST_ITEM_TAG});
        }
        if (nextLeafAncestorLi == null) {
            return;
        }
        if (this.needsDeleteAdjustment(nextLeafAncestorLi, li)) {
            this.executeDelete(this.getReferenceNode(endContainer, li, (Node)nextLeafAncestorLi), nextLeafAncestorLi, nextEmptyItemPlacehodlerLeaf, range);
            event.xPreventDefault();
        }
    }

    protected void onBackspace(org.xwiki.gwt.dom.client.Element li, Event event) {
        Range range = this.getTextArea().getDocument().getSelection().getRangeAt(0);
        if (!range.isCollapsed()) {
            return;
        }
        Node startContainer = range.getStartContainer();
        if (startContainer.getNodeType() == 3 && range.getStartOffset() != 0) {
            return;
        }
        Node previousLeaf = DOMUtils.getInstance().getPreviousLeaf(range);
        if (previousLeaf == null) {
            return;
        }
        org.xwiki.gwt.dom.client.Element previousLeafAncestorLi = (org.xwiki.gwt.dom.client.Element)DOMUtils.getInstance().getFirstAncestor(previousLeaf, new String[]{LIST_ITEM_TAG});
        Node previousEmptyItemPlacehodlerLeaf = null;
        if (previousLeafAncestorLi == null) {
            return;
        }
        if (this.needsDeleteAdjustment(li, previousLeafAncestorLi)) {
            if (this.isEmptyListItemPlaceholder(previousLeaf)) {
                range.setEndBefore(previousLeaf);
                previousEmptyItemPlacehodlerLeaf = previousLeaf;
            } else if (previousLeaf.getNodeName().equalsIgnoreCase(LIST_ITEM_TAG)) {
                range.setEnd((Node)previousLeafAncestorLi, 0);
            } else {
                range.setEndAfter(previousLeaf);
            }
            this.executeDelete(this.getReferenceNode(previousLeaf, previousLeafAncestorLi, (Node)li), li, previousEmptyItemPlacehodlerLeaf, range);
            event.xPreventDefault();
        }
    }

    protected boolean needsDeleteAdjustment(org.xwiki.gwt.dom.client.Element sourceListItem, org.xwiki.gwt.dom.client.Element destListItem) {
        if (sourceListItem == destListItem) {
            return false;
        }
        if (sourceListItem.isOrHasChild((Node)destListItem)) {
            return false;
        }
        Node commonAncestor = DOMUtils.getInstance().getNearestCommonAncestor((Node)sourceListItem, (Node)destListItem);
        Node commonListAncestor = DOMUtils.getInstance().getFirstAncestor(commonAncestor, new String[]{ORDERED_LIST_TAG, UNORDERED_LIST_TAG});
        return commonListAncestor != null && commonListAncestor == sourceListItem.getParentNode() || commonListAncestor == destListItem.getParentNode();
    }

    protected void executeDelete(Node reference, org.xwiki.gwt.dom.client.Element nextLi, Node skippedEmptyPlaceHolder, Range range) {
        int endOffset = range.getEndOffset();
        Node endContainer = range.getEndContainer();
        DocumentFragment extractedLi = DOMUtils.getInstance().extractNodeContents((Node)nextLi, 0, DOMUtils.getInstance().getLength((Node)nextLi));
        DOMUtils.getInstance().insertAfter((Node)extractedLi, reference);
        range.setEnd(endContainer, endOffset);
        this.getTextArea().getDocument().getSelection().removeAllRanges();
        this.getTextArea().getDocument().getSelection().addRange(range);
        org.xwiki.gwt.dom.client.Element liParentElt = (org.xwiki.gwt.dom.client.Element)nextLi.getParentElement();
        liParentElt.removeChild((Node)nextLi);
        if (liParentElt.getChildNodes().getLength() == 0) {
            liParentElt.getParentElement().removeChild((Node)liParentElt);
        }
        if (skippedEmptyPlaceHolder != null) {
            skippedEmptyPlaceHolder.getParentNode().removeChild(skippedEmptyPlaceHolder);
        }
    }

    private Node getReferenceNode(Node descendant, org.xwiki.gwt.dom.client.Element parentListItem, Node before) {
        Node refNode = descendant;
        while (!(refNode.getParentNode() == parentListItem || refNode.getParentNode().getNodeType() == 1 && org.xwiki.gwt.dom.client.Element.as((Node)refNode.getParentNode()).isOrHasChild((Node)org.xwiki.gwt.dom.client.Element.as((Node)before)))) {
            refNode = refNode.getParentNode();
        }
        return refNode;
    }

    public boolean isEmptyListItemPlaceholder(Node node) {
        return node.getNodeName().equalsIgnoreCase("br");
    }

    public void onKeyPress(KeyPressEvent event) {
        this.dispatchKey((Widget)event.getSource(), event.getNativeEvent().getKeyCode(), (Event)event.getNativeEvent());
    }

    protected void dispatchKey(Widget sender, int keyCode, Event originalEvent) {
        if (this.textArea != sender) {
            return;
        }
        Range range = this.textArea.getDocument().getSelection().getRangeAt(0);
        Node li = DOMUtils.getInstance().getFirstAncestor(range.getCommonAncestorContainer(), new String[]{LIST_ITEM_TAG});
        if (li == null) {
            return;
        }
        switch (keyCode) {
            case 46: {
                this.onDelete((org.xwiki.gwt.dom.client.Element)li, originalEvent);
                break;
            }
            case 8: {
                this.onBackspace((org.xwiki.gwt.dom.client.Element)li, originalEvent);
                break;
            }
        }
    }

    public void onKeyUp(KeyUpEvent event) {
        boolean needsCleanup;
        if (this.textArea != event.getSource()) {
            return;
        }
        boolean bl = needsCleanup = event.getNativeKeyCode() == 13 && !event.getNativeEvent().getShiftKey() || event.getNativeKeyCode() == 46 || event.getNativeKeyCode() == 8;
        if (!needsCleanup) {
            return;
        }
        this.cleanUp((org.xwiki.gwt.dom.client.Element)this.textArea.getDocument().getDocumentElement());
    }

    public void onKeyDown(KeyDownEvent event) {
    }

    public RichTextArea getTextArea() {
        return this.textArea;
    }

    public void setTextArea(RichTextArea textArea) {
        this.textArea = textArea;
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        return false;
    }

    public void onCommand(CommandManager sender, Command command, String param) {
        List<Command> needCleanup = Arrays.asList(Command.DELETE, Command.INDENT, Command.OUTDENT, RESET_COMMAND, Command.INSERT_ORDERED_LIST, Command.INSERT_UNORDERED_LIST);
        if (needCleanup.contains(command)) {
            this.cleanUp((org.xwiki.gwt.dom.client.Element)this.getTextArea().getDocument().getDocumentElement());
        }
    }
}

