/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.UIObject;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.Executable;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractStatefulPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.list.ListBehaviorAdjuster;
import org.xwiki.gwt.wysiwyg.client.plugin.list.exec.ListExecutable;

public class ListPlugin
extends AbstractStatefulPlugin
implements ClickHandler {
    private final Map<ToggleButton, Command> buttons = new HashMap<ToggleButton, Command>();
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");
    private ListBehaviorAdjuster behaviorAdjuster;

    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.getTextArea().getCommandManager().registerCommand(Command.INSERT_ORDERED_LIST, (Executable)new ListExecutable(textArea, true));
        this.getTextArea().getCommandManager().registerCommand(Command.INSERT_UNORDERED_LIST, (Executable)new ListExecutable(textArea, false));
        this.addFeature("orderedlist", Command.INSERT_ORDERED_LIST, Images.INSTANCE.ol(), Strings.INSTANCE.ol());
        this.addFeature("unorderedlist", Command.INSERT_UNORDERED_LIST, Images.INSTANCE.ul(), Strings.INSTANCE.ul());
        if (this.toolBarExtension.getFeatures().length > 0) {
            this.registerTextAreaHandlers();
            this.getUIExtensionList().add(this.toolBarExtension);
            this.behaviorAdjuster = (ListBehaviorAdjuster)GWT.create(ListBehaviorAdjuster.class);
            this.behaviorAdjuster.setTextArea(this.getTextArea());
            this.behaviorAdjuster.onCommand(this.getTextArea().getCommandManager(), new Command("reset"), null);
            this.saveRegistration(this.getTextArea().addKeyDownHandler((KeyDownHandler)this.behaviorAdjuster));
            this.saveRegistration(this.getTextArea().addKeyUpHandler((KeyUpHandler)this.behaviorAdjuster));
            this.saveRegistration(this.getTextArea().addKeyPressHandler((KeyPressHandler)this.behaviorAdjuster));
            this.getTextArea().getCommandManager().addCommandListener((CommandListener)this.behaviorAdjuster);
        }
    }

    private void addFeature(String name, Command command, ImageResource imageResource, String title) {
        if (this.getTextArea().getCommandManager().isSupported(command)) {
            ToggleButton button = new ToggleButton(new Image(imageResource));
            this.saveRegistration(button.addClickHandler((ClickHandler)this));
            button.setTitle(title);
            this.toolBarExtension.addFeature(name, (UIObject)button);
            this.buttons.put(button, command);
        }
    }

    public void destroy() {
        for (ToggleButton button : this.buttons.keySet()) {
            button.removeFromParent();
        }
        this.buttons.clear();
        this.toolBarExtension.clearFeatures();
        if (this.behaviorAdjuster != null) {
            this.getTextArea().getCommandManager().removeCommandListener((CommandListener)this.behaviorAdjuster);
            this.behaviorAdjuster = null;
        }
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        Command command = this.buttons.get(event.getSource());
        if (command != null && ((FocusWidget)event.getSource()).isEnabled()) {
            this.getTextArea().setFocus(true);
            this.getTextArea().getCommandManager().execute(command);
        }
    }

    public void update() {
        for (Map.Entry<ToggleButton, Command> entry : this.buttons.entrySet()) {
            if (!entry.getKey().isEnabled()) continue;
            entry.getKey().setDown(this.getTextArea().getCommandManager().isExecuted(entry.getValue()));
        }
    }
}

