/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xwiki.gwt.dom.client.DOMUtils;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.DocumentFragment;
import org.xwiki.gwt.dom.client.InnerHTMLListener;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroDisplayer
implements InnerHTMLListener {
    public static final String MACRO_STYLE_NAME = "macro";
    public static final String SELECTED_MACRO_STYLE_NAME = "macro-selected";
    public static final String BLOCK_MACRO_STYLE_NAME = "macro-block";
    public static final String INLINE_MACRO_STYLE_NAME = "macro-inline";
    public static final String START_MACRO_COMMENT_PREFIX = "startmacro:";
    public static final String STOP_MACRO_COMMENT_VALUE = "stopmacro";
    protected final DOMUtils domUtils = DOMUtils.getInstance();
    private RichTextArea textArea;

    public void destroy() {
        this.textArea.getDocument().removeInnerHTMLListener((InnerHTMLListener)this);
    }

    public RichTextArea getTextArea() {
        return this.textArea;
    }

    public void setTextArea(RichTextArea textArea) {
        if (this.textArea != null) {
            throw new IllegalStateException("Text area has already been set!");
        }
        this.textArea = textArea;
        textArea.getDocument().addInnerHTMLListener((InnerHTMLListener)this);
        this.display(this.getStartMacroCommentNodes((Node)textArea.getDocument().getBody()));
    }

    private void display(List<Node> startMacroComments) {
        for (Node start : startMacroComments) {
            this.display(start);
        }
    }

    private void display(Node start) {
        org.xwiki.gwt.dom.client.Element container;
        Node stop = start.getNextSibling();
        int siblingCount = 0;
        int openedMacrosCount = 0;
        while (stop != null) {
            if (stop.getNodeType() == 8) {
                if (stop.getNodeValue().startsWith(START_MACRO_COMMENT_PREFIX)) {
                    ++openedMacrosCount;
                } else if (STOP_MACRO_COMMENT_VALUE.equals(stop.getNodeValue())) {
                    if (openedMacrosCount == 0) break;
                    --openedMacrosCount;
                }
            }
            stop = stop.getNextSibling();
            ++siblingCount;
        }
        if (stop == null) {
            return;
        }
        if (siblingCount == 1 && this.isMacroContainer(start.getNextSibling())) {
            container = (org.xwiki.gwt.dom.client.Element)start.getNextSibling();
        } else {
            container = this.createMacroContainer(start, stop, siblingCount);
            this.setCollapsed(container, false);
        }
        container.setMetaData(this.extractMetaData(start, stop));
        this.setSelected(container, false);
    }

    protected org.xwiki.gwt.dom.client.Element createMacroContainer(Node start, Node stop, int siblingCount) {
        org.xwiki.gwt.dom.client.Element container = this.createReadOnlyBox();
        container.setClassName(MACRO_STYLE_NAME);
        MacroCall call = new MacroCall(start.getNodeValue());
        container.setTitle(call.getName() + " macro");
        container.appendChild((Node)this.createPlaceHolder(call));
        if (siblingCount > 0) {
            int startIndex = this.domUtils.getNodeIndex(start);
            int endIndex = startIndex + siblingCount + 1;
            org.xwiki.gwt.dom.client.Element output = (org.xwiki.gwt.dom.client.Element)this.textArea.getDocument().createDivElement().cast();
            output.setClassName("macro-output");
            output.appendChild((Node)this.domUtils.extractNodeContents(start.getParentNode(), startIndex + 1, endIndex));
            container.addClassName(this.isInLine(output) ? INLINE_MACRO_STYLE_NAME : BLOCK_MACRO_STYLE_NAME);
            container.appendChild((Node)output);
        }
        start.getParentNode().insertBefore((Node)container, start);
        return container;
    }

    private boolean isInLine(org.xwiki.gwt.dom.client.Element output) {
        for (Node child = output.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!this.domUtils.isBlock(child)) continue;
            return false;
        }
        return true;
    }

    protected org.xwiki.gwt.dom.client.Element createReadOnlyBox() {
        org.xwiki.gwt.dom.client.Element container = (org.xwiki.gwt.dom.client.Element)this.textArea.getDocument().createElement(this.getMacroContainerTagName());
        container.setAttribute("contentEditable", "false");
        return container;
    }

    private List<Node> getStartMacroCommentNodes(Node root) {
        Document document = (Document)root.getOwnerDocument();
        Iterator iterator = document.getIterator(root);
        ArrayList<Node> startMacroComments = new ArrayList<Node>();
        int openedMacrosCount = 0;
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.getNodeType() != 8) continue;
            if (node.getNodeValue().startsWith(START_MACRO_COMMENT_PREFIX)) {
                if (openedMacrosCount == 0) {
                    startMacroComments.add(node);
                }
                ++openedMacrosCount;
                continue;
            }
            if (!STOP_MACRO_COMMENT_VALUE.equals(node.getNodeValue())) continue;
            --openedMacrosCount;
        }
        return startMacroComments;
    }

    private DocumentFragment createPlaceHolder(MacroCall call) {
        Document document = this.textArea.getDocument();
        org.xwiki.gwt.dom.client.Element placeHolder = (org.xwiki.gwt.dom.client.Element)document.createSpanElement().cast();
        placeHolder.appendChild((Node)document.createTextNode(call.getName()));
        placeHolder.setClassName("macro-placeholder");
        DocumentFragment output = document.createDocumentFragment();
        output.appendChild((Node)placeHolder);
        return output;
    }

    private DocumentFragment extractMetaData(Node start, Node stop) {
        DocumentFragment metaData = this.textArea.getDocument().createDocumentFragment();
        metaData.appendChild(start);
        metaData.appendChild(stop);
        return metaData;
    }

    public void setSelected(org.xwiki.gwt.dom.client.Element container, boolean selected) {
        if (selected) {
            container.addClassName(SELECTED_MACRO_STYLE_NAME);
        } else {
            container.removeClassName(SELECTED_MACRO_STYLE_NAME);
        }
    }

    public boolean isSelected(org.xwiki.gwt.dom.client.Element container) {
        return container.hasClassName(SELECTED_MACRO_STYLE_NAME);
    }

    public boolean isMacroContainer(Node node) {
        return this.getMacroContainerTagName().equalsIgnoreCase(node.getNodeName()) && org.xwiki.gwt.dom.client.Element.as((Node)node).hasClassName(MACRO_STYLE_NAME);
    }

    public List<org.xwiki.gwt.dom.client.Element> getMacroContainers(org.xwiki.gwt.dom.client.Element root) {
        ArrayList<org.xwiki.gwt.dom.client.Element> containers = new ArrayList<org.xwiki.gwt.dom.client.Element>();
        NodeList divs = root.getElementsByTagName(this.getMacroContainerTagName());
        for (int i = 0; i < divs.getLength(); ++i) {
            org.xwiki.gwt.dom.client.Element div = (org.xwiki.gwt.dom.client.Element)((Element)divs.getItem(i)).cast();
            if (!this.isMacroContainer((Node)div)) continue;
            containers.add(div);
        }
        return containers;
    }

    protected String getMacroContainerTagName() {
        return "button";
    }

    public void setCollapsed(org.xwiki.gwt.dom.client.Element container, boolean collapsed) {
        boolean collapse;
        org.xwiki.gwt.dom.client.Element output = this.getOutput(container);
        boolean bl = collapse = collapsed || output == null;
        if (output != null) {
            output.getStyle().setDisplay(collapse ? Style.Display.NONE : Style.Display.BLOCK);
        }
        org.xwiki.gwt.dom.client.Element placeHolder = this.getPlaceHolder(container);
        placeHolder.getStyle().setDisplay(collapse ? Style.Display.INLINE : Style.Display.NONE);
    }

    public boolean isCollapsed(org.xwiki.gwt.dom.client.Element container) {
        return !Style.Display.NONE.getCssName().equals(this.getPlaceHolder(container).getStyle().getDisplay());
    }

    protected org.xwiki.gwt.dom.client.Element getOutput(org.xwiki.gwt.dom.client.Element container) {
        return (org.xwiki.gwt.dom.client.Element)this.getPlaceHolder(container).getNextSibling();
    }

    protected org.xwiki.gwt.dom.client.Element getPlaceHolder(org.xwiki.gwt.dom.client.Element container) {
        return (org.xwiki.gwt.dom.client.Element)container.getFirstChild();
    }

    public void onInnerHTMLChange(org.xwiki.gwt.dom.client.Element element) {
        if (element.getOwnerDocument() == this.textArea.getDocument()) {
            this.display(this.getStartMacroCommentNodes((Node)element));
        }
    }

    public String getSerializedMacroCall(org.xwiki.gwt.dom.client.Element container) {
        return container.getMetaData().getFirstChild().getNodeValue();
    }
}

