/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.macro;

import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.dom.client.Element;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.user.client.DeferredUpdater;
import org.xwiki.gwt.user.client.HandlerRegistrationCollection;
import org.xwiki.gwt.user.client.Updatable;
import org.xwiki.gwt.user.client.ui.rta.cmd.Command;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandListener;
import org.xwiki.gwt.user.client.ui.rta.cmd.CommandManager;
import org.xwiki.gwt.wysiwyg.client.plugin.macro.MacroDisplayer;

public class MacroSelector
implements Updatable,
MouseDownHandler,
KeyUpHandler,
CommandListener {
    private static final Command RESET = new Command("reset");
    private final MacroDisplayer displayer;
    private final DeferredUpdater updater = new DeferredUpdater((Updatable)this);
    private final List<Element> selectedContainers = new ArrayList<Element>();
    private final HandlerRegistrationCollection registrations = new HandlerRegistrationCollection();

    public MacroSelector(MacroDisplayer displayer) {
        this.displayer = displayer;
        this.registrations.add((Object)displayer.getTextArea().addMouseDownHandler((MouseDownHandler)this));
        this.registrations.add((Object)displayer.getTextArea().addKeyUpHandler((KeyUpHandler)this));
        displayer.getTextArea().getCommandManager().addCommandListener((CommandListener)this);
    }

    public void destroy() {
        this.selectedContainers.clear();
        this.registrations.removeHandlers();
        this.displayer.getTextArea().getCommandManager().removeCommandListener((CommandListener)this);
    }

    public void onMouseDown(MouseDownEvent event) {
        if (event.getSource() == this.displayer.getTextArea()) {
            Element target = (Element)event.getNativeEvent().getEventTarget().cast();
            if (this.displayer.isMacroContainer((Node)target)) {
                if (this.displayer.isSelected(target)) {
                    this.displayer.setCollapsed(target, !this.displayer.isCollapsed(target));
                } else {
                    this.update();
                }
            } else {
                this.updater.deferUpdate();
            }
        }
    }

    public void onKeyUp(KeyUpEvent event) {
        if (event.getSource() == this.displayer.getTextArea()) {
            this.updater.deferUpdate();
        }
    }

    public boolean onBeforeCommand(CommandManager sender, Command command, String param) {
        if (RESET.equals((Object)command)) {
            this.selectedContainers.clear();
        }
        return false;
    }

    public void onCommand(CommandManager sender, Command command, String param) {
        if (sender == this.displayer.getTextArea().getCommandManager()) {
            this.updater.deferUpdate();
        }
    }

    public void update() {
        for (Element container : this.selectedContainers) {
            this.displayer.setSelected(container, false);
        }
        this.selectedContainers.clear();
        Selection selection = this.displayer.getTextArea().getDocument().getSelection();
        for (int i = 0; i < selection.getRangeCount(); ++i) {
            Node selectedNode;
            Range range = selection.getRangeAt(i);
            if (range.getStartContainer() != range.getEndContainer() || range.getStartContainer().getNodeType() != 1 || range.getEndOffset() - range.getStartOffset() != 1 || !this.displayer.isMacroContainer(selectedNode = range.getStartContainer().getChildNodes().getItem(range.getStartOffset()))) continue;
            Element container = (Element)selectedNode;
            this.selectedContainers.add(container);
            this.displayer.setSelected(container, true);
        }
    }

    public boolean canUpdate() {
        return this.displayer.getTextArea().isAttached() && this.displayer.getTextArea().isEnabled();
    }

    public int getMacroCount() {
        return this.selectedContainers.size();
    }

    public Element getMacro(int index) {
        return this.selectedContainers.get(index);
    }

    public MacroDisplayer getDisplayer() {
        return this.displayer;
    }
}

