/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.symbol;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import org.xwiki.gwt.wysiwyg.client.plugin.symbol.SymbolCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolPalette
extends Composite
implements HasSelectionHandlers<String>,
ClickHandler {
    private SymbolCell selectedCell;

    public SymbolPalette(Object[][] symbols, int rows, int columns) {
        Grid symbolGrid = new Grid(columns, rows);
        symbolGrid.addStyleName("xSymbolPalette");
        symbolGrid.setBorderWidth(0);
        symbolGrid.setCellPadding(0);
        symbolGrid.setCellSpacing(1);
        symbolGrid.addClickHandler((ClickHandler)this);
        int j = 0;
        int k = 0;
        for (int i = 0; i < symbols.length; ++i) {
            if (!((Boolean)symbols[i][2]).booleanValue()) continue;
            SymbolCell charCell = new SymbolCell(symbols[i][0].toString());
            charCell.setTitle(symbols[i][3].toString());
            symbolGrid.setWidget(k, j, (Widget)charCell);
            symbolGrid.getCellFormatter().setHorizontalAlignment(k, j, HasHorizontalAlignment.ALIGN_CENTER);
            if (++j != rows) continue;
            j = 0;
            ++k;
        }
        this.initWidget((Widget)symbolGrid);
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<String> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    protected Grid getSymbolGrid() {
        return (Grid)this.getWidget();
    }

    public void onClick(ClickEvent event) {
        HTMLTable.Cell cell;
        if (event.getSource() == this.getSymbolGrid() && (cell = this.getSymbolGrid().getCellForEvent(event)) != null) {
            this.setSelectedCell((SymbolCell)this.getSymbolGrid().getWidget(cell.getRowIndex(), cell.getCellIndex()));
            SelectionEvent.fire((HasSelectionHandlers)this, (Object)this.getSelectedSymbol());
        }
    }

    private void setSelectedCell(SymbolCell cell) {
        if (this.selectedCell != cell) {
            if (this.selectedCell != null) {
                this.selectedCell.setSelected(false);
            }
            this.selectedCell = cell;
            if (this.selectedCell != null) {
                this.selectedCell.setSelected(true);
            }
        }
    }

    public String getSelectedSymbol() {
        return this.selectedCell != null ? this.selectedCell.getSymbol() : null;
    }

    public void setSelectedSymbol(String symbol) {
        if (symbol != null) {
            for (int i = 0; i < this.getSymbolGrid().getRowCount(); ++i) {
                for (int j = 0; j < this.getSymbolGrid().getColumnCount(); ++j) {
                    SymbolCell cell = (SymbolCell)this.getSymbolGrid().getWidget(i, j);
                    if (!cell.getSymbol().equals(symbol)) continue;
                    this.setSelectedCell(cell);
                    return;
                }
            }
        }
        this.setSelectedCell(null);
    }
}

