/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.sync;

import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.UIObject;
import org.xwiki.gwt.dom.client.Document;
import org.xwiki.gwt.dom.client.Range;
import org.xwiki.gwt.dom.client.RangeFactory;
import org.xwiki.gwt.dom.client.Selection;
import org.xwiki.gwt.user.client.Config;
import org.xwiki.gwt.user.client.Console;
import org.xwiki.gwt.user.client.Timer;
import org.xwiki.gwt.user.client.TimerListener;
import org.xwiki.gwt.user.client.ui.rta.RichTextArea;
import org.xwiki.gwt.wysiwyg.client.Images;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.diff.Diff;
import org.xwiki.gwt.wysiwyg.client.diff.DifferentiationFailedException;
import org.xwiki.gwt.wysiwyg.client.diff.Revision;
import org.xwiki.gwt.wysiwyg.client.diff.ToString;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.AbstractPlugin;
import org.xwiki.gwt.wysiwyg.client.plugin.internal.FocusWidgetUIExtension;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncResult;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncServiceAsync;
import org.xwiki.gwt.wysiwyg.client.plugin.sync.SyncTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncPlugin
extends AbstractPlugin
implements ClickHandler,
TimerListener,
AsyncCallback<SyncResult> {
    public static final int DEFAULT_SYNC_DELAY = 3000;
    private PushButton sync;
    private Timer timer;
    private final FocusWidgetUIExtension toolBarExtension = new FocusWidgetUIExtension("toolbar");
    private String pageName;
    private int version = 0;
    private String initialContent;
    private String syncedContent;
    private Revision syncedRevision;
    private boolean syncInProgress = false;
    private int id;
    private boolean sendCursor = false;
    private boolean maintainCursor = true;
    private final SyncServiceAsync syncService;

    public SyncPlugin(SyncServiceAsync syncService) {
        this.syncService = syncService;
    }

    @Override
    public void init(RichTextArea textArea, Config config) {
        super.init(textArea, config);
        this.id = Math.abs(Random.nextInt());
        this.pageName = config.getParameter("syncPage");
        if (this.pageName == null) {
            return;
        }
        this.sync = new PushButton(new Image(Images.INSTANCE.sync()));
        this.saveRegistration(this.sync.addClickHandler((ClickHandler)this));
        this.sync.setTitle(Strings.INSTANCE.sync());
        this.toolBarExtension.addFeature("sync", (UIObject)this.sync);
        this.getUIExtensionList().add(this.toolBarExtension);
        String string = this.initialContent = this.version == 0 ? "" : this.getTextArea().getHTML();
        if (this.initialContent == null) {
            this.initialContent = "";
        }
        this.timer = new Timer();
        this.timer.addTimerListener((TimerListener)this);
        this.timer.scheduleRepeating(Integer.parseInt(this.getConfig().getParameter("sync_delay", String.valueOf(3000))));
    }

    @Override
    public void destroy() {
        this.sync.removeFromParent();
        this.sync = null;
        this.toolBarExtension.clearFeatures();
        this.timer.removeTimerListener((TimerListener)this);
        this.timer.cancel();
        this.timer = null;
        super.destroy();
    }

    public void onClick(ClickEvent event) {
        if (event.getSource() == this.sync) {
            this.onSync();
        }
    }

    public void onElapsed(Timer sender) {
        if (sender == this.timer) {
            this.onSync();
        }
    }

    public synchronized void onSync() {
        if (this.syncInProgress) {
            this.debugMessage("Cannot sync because sync is in progress");
            return;
        }
        this.syncInProgress = true;
        try {
            this.syncedRevision = null;
            if (this.version != 0) {
                if (this.sendCursor) {
                    this.insertCursor(this.getTextArea().getDocument());
                }
                String string = this.syncedContent = this.version == 0 ? "" : this.getTextArea().getHTML();
                if (this.sendCursor) {
                    this.removeCursor(this.getTextArea().getDocument());
                }
                if (this.version > 0 && !this.initialContent.equals(this.syncedContent)) {
                    try {
                        this.syncedRevision = Diff.diff(ToString.stringToArray(this.initialContent), ToString.stringToArray(this.syncedContent));
                    }
                    catch (DifferentiationFailedException e) {
                        this.showErrorAndResetSync(e);
                    }
                }
            } else {
                this.syncedContent = "";
            }
            boolean syncReset = this.version == 0 && this.getConfig().getParameter("syncReset", "0").equals("1");
            this.syncService.syncEditorContent(this.syncedRevision, this.pageName, this.version, syncReset, this);
        }
        catch (Throwable th) {
            this.debugMessage("error in onSync ");
            this.showErrorAndResetSync(th);
        }
    }

    private void insertCursor(Document doc) {
        block11: {
            try {
                int color = this.id - 10 * (int)Math.floor(this.id / 10);
                SpanElement cursorNode = doc.createSpanElement();
                cursorNode.setId("cursor-" + this.id);
                cursorNode.setClassName("cursor cursor-" + color);
                cursorNode.setAttribute("style", "background-color: #" + color + ";");
                Range range = doc.getSelection().getRangeAt(0);
                try {
                    if (range == null) break block11;
                    if (range.getStartContainer().equals((Object)doc) && range.getEndContainer().equals((Object)doc) && range.getStartOffset() == 0 && range.getEndOffset() == 0) {
                        this.debugMessage("Cursor at start.. let's not handle it");
                        break block11;
                    }
                    this.debugMessage("Start container: " + range.getStartContainer());
                    this.debugMessage("Start offset: " + range.getStartOffset());
                    this.debugMessage("End container: " + range.getEndContainer());
                    this.debugMessage("End offset: " + range.getEndOffset());
                    range.surroundContents((Node)cursorNode);
                    this.debugMessage("surrounding range ok");
                }
                catch (Exception e) {
                    try {
                        Selection selection;
                        this.debugMessage("error surrounding range");
                        this.debugMessage("Exception: " + e.getMessage());
                        e.printStackTrace();
                        this.debugMessage(e.toString());
                        if (range != null) {
                            this.debugMessage("Start container: " + range.getStartContainer());
                            this.debugMessage("Start offset: " + range.getStartOffset());
                            this.debugMessage("End container: " + range.getEndContainer());
                            this.debugMessage("End offset: " + range.getEndOffset());
                            try {
                                this.debugMessage("Range content: " + range.cloneContents().getInnerHTML());
                            }
                            catch (Exception e3) {
                                // empty catch block
                            }
                        }
                        if ((selection = doc.getSelection()) != null) {
                            this.debugMessage("Selection range count: " + selection.getRangeCount());
                        }
                    }
                    catch (Exception e2) {
                        this.debugMessage("Exception: " + e2.getMessage());
                    }
                }
            }
            catch (Exception e) {
                this.debugMessage("Uncaught exception in insertCursor: " + e.getMessage());
            }
        }
    }

    private void removeCursor(Document doc) {
        try {
            Element cursorNode = null;
            NodeList list = doc.getElementsByTagName("span");
            for (int i = 0; i < list.getLength(); ++i) {
                Element element = (Element)list.getItem(i);
                if (!element.getId().equals("cursor-" + this.id)) continue;
                cursorNode = element;
            }
            if (cursorNode != null) {
                this.debugMessage("found cursor element");
                Node firstNode = null;
                Node lastNode = null;
                Element pNode = cursorNode;
                NodeList childs = cursorNode.getChildNodes();
                int nb = childs.getLength();
                for (int i = nb - 1; i >= 0; --i) {
                    Node node = childs.getItem(i);
                    if (i == 0) {
                        firstNode = node;
                    }
                    if (i == nb - 1) {
                        lastNode = node;
                    }
                    cursorNode.removeChild(node);
                    cursorNode.getParentNode().insertBefore(node, (Node)pNode);
                    pNode = node;
                }
                Node previousNode = cursorNode.getPreviousSibling();
                this.debugMessage("removing cursor node");
                cursorNode.getParentNode().removeChild((Node)cursorNode);
                this.debugMessage("creating new range");
                Range range = RangeFactory.INSTANCE.createRange(doc);
                if (firstNode != null) {
                    this.debugMessage("set range with first node and last node");
                    range.setStartBefore(firstNode);
                    range.setEndAfter(lastNode);
                } else if (previousNode != null) {
                    this.debugMessage("set range with previous node");
                    Node nextNode = previousNode.getNextSibling();
                    if (nextNode != null) {
                        range.setStart(nextNode, 0);
                    } else {
                        range.setStartAfter(previousNode);
                        range.setEndAfter(previousNode);
                        range.collapse(true);
                    }
                }
                doc.getSelection().removeAllRanges();
                doc.getSelection().addRange(range);
                this.getTextArea().setFocus(true);
            } else {
                this.debugMessage("could not find cursor element");
            }
        }
        catch (Exception e) {
            this.debugMessage("Uncaught exception in insertCursor: " + e.getMessage());
        }
    }

    public void debugMessage(String text) {
        if ("true".equals(this.getConfig().getParameter("debug", "false"))) {
            Console.getInstance().info((Object)text, new Object[0]);
        }
    }

    public synchronized void onFailure(Throwable caught) {
        this.showErrorAndResetSync(caught);
    }

    private void showErrorAndResetSync(Throwable caught) {
        this.showError(caught, new AsyncCallback(){

            public void onFailure(Throwable throwable) {
                SyncPlugin.this.syncInProgress = false;
            }

            public void onSuccess(Object o) {
                SyncPlugin.this.syncInProgress = false;
            }
        });
    }

    public synchronized void onSuccess(SyncResult result) {
        this.debugMessage("received result from server");
        if (result == null) {
            this.syncInProgress = false;
            return;
        }
        SyncResult syncResult = result;
        Revision newRevision = syncResult.getRevision();
        try {
            if (newRevision != null) {
                if (this.maintainCursor && this.version != 0) {
                    this.insertCursor(this.getTextArea().getDocument());
                }
                String localContent = this.version == 0 ? "" : this.getTextArea().getHTML();
                String newHTMLContent = "";
                try {
                    newHTMLContent = ToString.arrayToString(newRevision.patch(ToString.stringToArray(this.initialContent)));
                }
                catch (Exception e) {
                    this.debugMessage("Exception while patching initial content: " + e.getMessage());
                    this.debugMessage("Initial content was: " + this.initialContent);
                    this.showErrorAndResetSync(e);
                }
                String futureInitialContent = newHTMLContent;
                if (this.version != 0 && !localContent.equals(this.initialContent)) {
                    try {
                        Revision localRevision = Diff.diff(ToString.stringToArray(this.initialContent), ToString.stringToArray(localContent));
                        Revision localRevision2 = SyncTools.relocateRevision(localRevision, newRevision);
                        newHTMLContent = ToString.arrayToString(localRevision2.patch(ToString.stringToArray(newHTMLContent)));
                    }
                    catch (Exception e) {
                        this.debugMessage("Exception while applying local revision: " + e.getMessage());
                    }
                }
                this.initialContent = futureInitialContent;
                this.setHTML(newHTMLContent);
                if ((this.maintainCursor || this.sendCursor) && this.version != 0) {
                    this.removeCursor(this.getTextArea().getDocument());
                }
            } else {
                this.initialContent = this.syncedContent;
            }
            this.version = syncResult.getVersion();
            this.syncInProgress = false;
        }
        catch (Throwable e) {
            this.showErrorAndResetSync(e);
        }
    }

    private void setHTML(String newHTMLContent) {
        this.getTextArea().setHTML(newHTMLContent);
    }

    public void showDialog(String title, String message, AsyncCallback cb) {
        try {
            Console.getInstance().error((Object)(title + "\n\n" + message), new Object[0]);
            cb.onSuccess(null);
        }
        catch (Throwable e) {
            this.debugMessage("Error displaying failed " + e.getMessage());
            cb.onFailure(e);
        }
    }

    public void showError(Throwable caught, AsyncCallback<?> cb) {
        if (caught != null) {
            caught.printStackTrace();
            this.debugMessage("Error is: " + caught.toString());
        }
        this.showError("", caught == null ? "" : caught.toString(), cb);
    }

    public void showError(String text, AsyncCallback<?> cb) {
        this.showError("", text, cb);
    }

    public void showError(String code, String text, AsyncCallback<?> cb) {
        this.debugMessage("Error ready to display");
        String message = "An error occured. Its code is " + code + ".\r\n\r\n" + text;
        this.debugMessage("Error displaying: " + message);
        this.showDialog("Synchronize", message, cb);
    }
}

