/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.plugin.sync;

import java.util.HashMap;
import java.util.Map;
import org.xwiki.gwt.wysiwyg.client.diff.Chunk;
import org.xwiki.gwt.wysiwyg.client.diff.Delta;
import org.xwiki.gwt.wysiwyg.client.diff.Revision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyncTools {
    private SyncTools() {
    }

    public static Revision relocateRevision(Revision rev2, Revision rev1) {
        Chunk revised;
        Chunk orig;
        Delta delta;
        int i;
        HashMap<Chunk, Integer> shiftList = new HashMap<Chunk, Integer>();
        for (i = 0; i < rev1.size(); ++i) {
            delta = rev1.getDelta(i);
            orig = delta.getOriginal();
            revised = delta.getRevised();
            if (revised.size() <= orig.size()) continue;
            int origpos = orig.anchor() + 1;
            String origstr = (String)orig.chunk().get(1);
            String revisedstr1 = (String)revised.chunk().get(1);
            String revisedstr2 = (String)revised.chunk().get(revised.chunk().size() - 1);
            int nbunreloc = orig.size() - revised.size();
            SyncTools.updateRevision(rev2, origpos, origstr, revisedstr1, revisedstr2, nbunreloc, shiftList);
        }
        for (i = 0; i < rev1.size(); ++i) {
            delta = rev1.getDelta(i);
            orig = delta.getOriginal();
            revised = delta.getRevised();
            if (orig.size() == revised.size()) continue;
            int position = orig.anchor();
            int deltaSize = revised.size() - orig.size();
            SyncTools.relocateRevision(rev2, position, deltaSize);
        }
        for (Chunk chunk : shiftList.keySet()) {
            int nbreloc = (Integer)shiftList.get(chunk);
            chunk.moveAnchor(nbreloc);
        }
        return rev2;
    }

    private static void updateRevision(Revision rev2, int position, String origchar, String newchar1, String newchar2, int nbunreloc, Map<Chunk, Integer> shiftList) {
        for (int i = 0; i < rev2.size(); ++i) {
            String origchar2;
            Delta delta = rev2.getDelta(i);
            Chunk orig = delta.getOriginal();
            Chunk revised = delta.getRevised();
            if (orig.anchor() == position && origchar.equals(origchar2 = (String)orig.chunk().get(0))) {
                orig.chunk().set(0, newchar2);
                revised.chunk().set(0, newchar2);
            }
            if (orig.anchor() + orig.size() - 1 != position || !origchar.equals(origchar2 = (String)orig.chunk().get(orig.size() - 1))) continue;
            orig.chunk().set(orig.size() - 1, newchar1);
            revised.chunk().set(revised.size() - 1, newchar1);
            shiftList.put(orig, new Integer(nbunreloc));
            shiftList.put(revised, new Integer(nbunreloc));
        }
    }

    private static void relocateRevision(Revision rev2, int position, int deltaSize) {
        for (int j = 0; j < rev2.size(); ++j) {
            Delta delta2 = rev2.getDelta(j);
            Chunk orig2 = delta2.getOriginal();
            Chunk revised2 = delta2.getRevised();
            if (orig2.anchor() < position) continue;
            orig2.moveAnchor(deltaSize);
            revised2.moveAnchor(deltaSize);
        }
    }
}

