/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.widget.wizard.util;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListener;
import org.xwiki.gwt.user.client.ui.wizard.NavigationListenerCollection;
import org.xwiki.gwt.user.client.ui.wizard.SourcesNavigationEvents;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractSelectorWizardStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectorAggregatorWizardStep<T>
extends AbstractSelectorWizardStep<T>
implements SelectionHandler<Integer>,
SourcesNavigationEvents,
NavigationListener {
    private static final String STYLE_LOADING = "loading";
    private static final String STYLE_ERROR = "errormessage";
    private Map<String, WizardStep> steps = new HashMap<String, WizardStep>();
    private Map<WizardStep, Boolean> initialized = new HashMap<WizardStep, Boolean>();
    private final TabPanel tabPanel = new TabPanel();
    private final FlowPanel mainPanel = new FlowPanel();
    private NavigationListenerCollection listeners = new NavigationListenerCollection();

    public AbstractSelectorAggregatorWizardStep() {
        this.mainPanel.addStyleName("xSelectorAggregatorStep");
        this.tabPanel.addStyleName("xStepsTabs");
        for (String stepName : this.getStepNames()) {
            this.tabPanel.add((Widget)new FlowPanel(), stepName);
        }
        this.tabPanel.addSelectionHandler((SelectionHandler)this);
        this.mainPanel.add((Widget)this.tabPanel);
    }

    protected WizardStep getStep(String name) {
        if (this.steps.get(name) == null) {
            WizardStep instance = this.getStepInstance(name);
            this.steps.put(name, instance);
            if (instance instanceof SourcesNavigationEvents) {
                ((SourcesNavigationEvents)instance).addNavigationListener((NavigationListener)this);
            }
            this.initialized.put(instance, false);
        }
        return this.steps.get(name);
    }

    protected abstract WizardStep getStepInstance(String var1);

    protected abstract List<String> getStepNames();

    protected String getDefaultStepName() {
        return this.getStepNames().get(0);
    }

    public void onSelection(SelectionEvent<Integer> event) {
        if (event.getSource() != this.tabPanel) {
            return;
        }
        this.tabPanel.addStyleName(STYLE_LOADING);
        String stepName = this.tabPanel.getTabBar().getTabHTML(((Integer)event.getSelectedItem()).intValue());
        final WizardStep stepToShow = this.getStep(stepName);
        final FlowPanel stepPanel = (FlowPanel)this.tabPanel.getWidget(this.tabPanel.getDeckPanel().getVisibleWidget());
        if (stepPanel.getWidgetCount() > 0) {
            stepPanel.getWidget(0).setVisible(false);
        }
        this.lazyInitializeStep(stepToShow, new AsyncCallback<Object>(){

            public void onSuccess(Object result) {
                AbstractSelectorAggregatorWizardStep.this.onStepInitialized(stepToShow, stepPanel);
            }

            public void onFailure(Throwable caught) {
                stepPanel.setVisible(true);
                AbstractSelectorAggregatorWizardStep.this.tabPanel.removeStyleName(AbstractSelectorAggregatorWizardStep.STYLE_LOADING);
                AbstractSelectorAggregatorWizardStep.this.showError(Strings.INSTANCE.linkErrorLoadingData(), (Panel)stepPanel);
            }
        });
    }

    private void onStepInitialized(WizardStep step, FlowPanel stepPanel) {
        if (stepPanel.getWidgetCount() > 0 && stepPanel.getWidget(0).getStyleName().contains(STYLE_ERROR)) {
            stepPanel.clear();
        }
        if (stepPanel.getWidgetCount() == 0) {
            stepPanel.add(step.display());
        }
        stepPanel.getWidget(0).setVisible(true);
        this.tabPanel.removeStyleName(STYLE_LOADING);
        if (step instanceof AbstractSelectorWizardStep) {
            ((AbstractSelectorWizardStep)step).setActive();
        }
    }

    private void showError(String message, Panel panel) {
        panel.clear();
        Label error = new Label(message);
        error.addStyleName(STYLE_ERROR);
        panel.add((Widget)error);
    }

    protected void selectTab(String tabName) {
        for (int i = 0; i < this.tabPanel.getTabBar().getTabCount(); ++i) {
            if (!this.tabPanel.getTabBar().getTabHTML(i).equals(tabName)) continue;
            this.tabPanel.selectTab(i);
            break;
        }
    }

    private WizardStep getCurrentStep() {
        String selectedStepName = this.getSelectedStepName();
        return this.getStep(selectedStepName == null ? this.getDefaultStepName() : selectedStepName);
    }

    private String getSelectedStepName() {
        int selectedTab = this.tabPanel.getTabBar().getSelectedTab();
        String currentStepName = null;
        if (selectedTab > 0) {
            currentStepName = this.tabPanel.getTabBar().getTabHTML(selectedTab);
        }
        return currentStepName;
    }

    public Widget display() {
        return this.mainPanel;
    }

    @Override
    public String getDirectionName(NavigationListener.NavigationDirection direction) {
        return this.getCurrentStep().getDirectionName(direction);
    }

    public String getNextStep() {
        return this.getCurrentStep().getNextStep();
    }

    @Override
    public Object getResult() {
        return this.getCurrentStep().getResult();
    }

    @Override
    public void init(Object data, final AsyncCallback<?> cb) {
        for (WizardStep step : this.initialized.keySet()) {
            this.initialized.put(step, false);
        }
        super.init(data, new AsyncCallback<Object>(){

            public void onSuccess(Object result) {
                AbstractSelectorAggregatorWizardStep.this.dispatchInit(cb);
            }

            public void onFailure(Throwable caught) {
                cb.onFailure(caught);
            }
        });
    }

    private void dispatchInit(AsyncCallback<?> cb) {
        String stepName = this.getRequiredStep();
        if (stepName == null && (stepName = this.getSelectedStepName()) == null) {
            stepName = this.getDefaultStepName();
        }
        this.selectTab(stepName);
        cb.onSuccess(null);
    }

    private void lazyInitializeStep(final WizardStep step, final AsyncCallback<?> cb) {
        if (!this.initialized.get(step).booleanValue()) {
            step.init(this.getData(), (AsyncCallback)new AsyncCallback<Object>(){

                public void onSuccess(Object result) {
                    AbstractSelectorAggregatorWizardStep.this.initialized.put(step, true);
                    if (cb != null) {
                        cb.onSuccess(null);
                    }
                }

                public void onFailure(Throwable caught) {
                    if (cb != null) {
                        cb.onFailure(caught);
                    }
                }
            });
            return;
        }
        cb.onSuccess(null);
    }

    protected String getRequiredStep() {
        return null;
    }

    public void onCancel() {
        this.getCurrentStep().onCancel();
    }

    public void onSubmit(AsyncCallback<Boolean> async) {
        this.getCurrentStep().onSubmit(async);
    }

    public void addNavigationListener(NavigationListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void onDirection(NavigationListener.NavigationDirection direction) {
        this.listeners.fireNavigationEvent(direction);
    }
}

