/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.widget.wizard.util;

import java.util.ArrayList;
import java.util.List;
import org.xwiki.gwt.user.client.StringUtils;
import org.xwiki.gwt.user.client.ui.wizard.WizardStep;
import org.xwiki.gwt.wysiwyg.client.Strings;
import org.xwiki.gwt.wysiwyg.client.widget.wizard.util.AbstractEntitySelectorAggregatorWizardStep;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityLink;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentSelectorAggregatorWizardStep<T extends EntityConfig>
extends AbstractEntitySelectorAggregatorWizardStep<T> {
    private final boolean selectionLimitedToCurrentPage;
    private String stepTitle;
    private WizardStep currentPageSelector;
    private WizardStep allPagesSelector;

    public AttachmentSelectorAggregatorWizardStep(boolean selectionLimitedToCurrentPage, WikiServiceAsync wikiService) {
        super(wikiService);
        this.selectionLimitedToCurrentPage = selectionLimitedToCurrentPage;
    }

    @Override
    protected String getRequiredStep() {
        EntityReference origin = ((EntityLink)this.getData()).getOrigin();
        EntityReference destination = ((EntityLink)this.getData()).getDestination();
        if (this.selectionLimitedToCurrentPage || StringUtils.isEmpty((String)((EntityConfig)((EntityLink)this.getData()).getData()).getReference()) || this.samePage(origin, destination)) {
            return Strings.INSTANCE.selectorSelectFromCurrentPage();
        }
        return Strings.INSTANCE.selectorSelectFromAllPages();
    }

    private boolean samePage(EntityReference origin, EntityReference destination) {
        return StringUtils.areEqual((String)origin.getPageName(), (String)destination.getPageName()) && StringUtils.areEqual((String)origin.getSpaceName(), (String)destination.getSpaceName()) && StringUtils.areEqual((String)origin.getWikiName(), (String)destination.getWikiName());
    }

    @Override
    protected WizardStep getStepInstance(String name) {
        if (name.equals(Strings.INSTANCE.selectorSelectFromCurrentPage())) {
            return this.currentPageSelector;
        }
        if (name.equals(Strings.INSTANCE.selectorSelectFromAllPages())) {
            return this.allPagesSelector;
        }
        return null;
    }

    public void setCurrentPageSelector(WizardStep currentPageSelector) {
        this.currentPageSelector = currentPageSelector;
    }

    public void setAllPagesSelector(WizardStep allPagesSelector) {
        this.allPagesSelector = allPagesSelector;
    }

    @Override
    protected List<String> getStepNames() {
        ArrayList<String> stepNames = new ArrayList<String>();
        stepNames.add(Strings.INSTANCE.selectorSelectFromCurrentPage());
        if (!this.selectionLimitedToCurrentPage) {
            stepNames.add(Strings.INSTANCE.selectorSelectFromAllPages());
        }
        return stepNames;
    }

    public String getStepTitle() {
        return this.stepTitle;
    }

    public void setStepTitle(String stepTitle) {
        this.stepTitle = stepTitle;
    }
}

