/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.gwt.wysiwyg.client.wiki;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.gwt.wysiwyg.client.wiki.Attachment;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityConfig;
import org.xwiki.gwt.wysiwyg.client.wiki.EntityReference;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiPage;
import org.xwiki.gwt.wysiwyg.client.wiki.WikiServiceAsync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiServiceAsyncCacheProxy
implements WikiServiceAsync {
    private final WikiServiceAsync service;
    private Boolean isMultiWiki;
    private List<String> virtualWikiNamesList;
    private final Map<EntityReference, String> uploadURLCache = new HashMap<EntityReference, String>();

    public WikiServiceAsyncCacheProxy(WikiServiceAsync service) {
        this.service = service;
    }

    @Override
    public void getPageNames(String wikiName, String spaceName, AsyncCallback<List<String>> async) {
        this.service.getPageNames(wikiName, spaceName, async);
    }

    @Override
    public void getRecentlyModifiedPages(int start, int count, AsyncCallback<List<WikiPage>> async) {
        this.service.getRecentlyModifiedPages(start, count, async);
    }

    @Override
    public void getMatchingPages(String keyword, int start, int count, AsyncCallback<List<WikiPage>> async) {
        this.service.getMatchingPages(keyword, start, count, async);
    }

    @Override
    public void getSpaceNames(String wikiName, AsyncCallback<List<String>> async) {
        this.service.getSpaceNames(wikiName, async);
    }

    @Override
    public void getVirtualWikiNames(final AsyncCallback<List<String>> async) {
        if (this.virtualWikiNamesList == null) {
            this.service.getVirtualWikiNames(new AsyncCallback<List<String>>(){

                public void onFailure(Throwable caught) {
                    async.onFailure(caught);
                }

                public void onSuccess(List<String> result) {
                    WikiServiceAsyncCacheProxy.this.virtualWikiNamesList = result;
                    async.onSuccess((Object)WikiServiceAsyncCacheProxy.this.virtualWikiNamesList);
                }
            });
        } else {
            async.onSuccess(this.virtualWikiNamesList);
        }
    }

    @Override
    public void isMultiWiki(final AsyncCallback<Boolean> async) {
        if (this.isMultiWiki == null) {
            this.service.isMultiWiki(new AsyncCallback<Boolean>(){

                public void onFailure(Throwable caught) {
                    async.onFailure(caught);
                }

                public void onSuccess(Boolean result) {
                    WikiServiceAsyncCacheProxy.this.isMultiWiki = result;
                    async.onSuccess((Object)WikiServiceAsyncCacheProxy.this.isMultiWiki);
                }
            });
        } else {
            async.onSuccess((Object)this.isMultiWiki);
        }
    }

    @Override
    public void getEntityConfig(EntityReference origin, EntityReference destination, AsyncCallback<EntityConfig> async) {
        this.service.getEntityConfig(origin, destination, async);
    }

    @Override
    public void getAttachment(EntityReference attachmentReference, AsyncCallback<Attachment> async) {
        this.service.getAttachment(attachmentReference, async);
    }

    @Override
    public void getImageAttachments(EntityReference documentReference, AsyncCallback<List<Attachment>> async) {
        this.service.getImageAttachments(documentReference, async);
    }

    @Override
    public void getAttachments(EntityReference documentReference, AsyncCallback<List<Attachment>> async) {
        this.service.getAttachments(documentReference, async);
    }

    @Override
    public void getUploadURL(final EntityReference documentReference, final AsyncCallback<String> async) {
        if (this.uploadURLCache.containsKey(documentReference)) {
            async.onSuccess((Object)this.uploadURLCache.get(documentReference));
        } else {
            this.service.getUploadURL(documentReference, new AsyncCallback<String>(){

                public void onFailure(Throwable caught) {
                    async.onFailure(caught);
                }

                public void onSuccess(String result) {
                    WikiServiceAsyncCacheProxy.this.uploadURLCache.put(documentReference.clone(), result);
                    async.onSuccess((Object)result);
                }
            });
        }
    }

    @Override
    public void parseLinkReference(String linkReference, EntityReference.EntityType entityType, EntityReference baseReference, AsyncCallback<EntityReference> async) {
        this.service.parseLinkReference(linkReference, entityType, baseReference, async);
    }
}

