/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.Map;
import org.xwiki.rendering.internal.renderer.ParametersPrinter;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHTMLMacroRenderer {
    private static final String COMMENT_SEPARATOR = "|-|";
    private ParametersPrinter parametersPrinter = new ParametersPrinter();

    public void render(XHTMLWikiPrinter printer, String name, Map<String, String> parameters, String content) {
        this.beginRender(printer, name, parameters, content);
        this.endRender(printer);
    }

    public void beginRender(XHTMLWikiPrinter printer, String name, Map<String, String> parameters, String content) {
        StringBuilder buffer = new StringBuilder("startmacro:");
        buffer.append(name);
        buffer.append(COMMENT_SEPARATOR);
        if (!parameters.isEmpty()) {
            buffer.append(this.parametersPrinter.print(parameters, '\\'));
        }
        if (content != null) {
            buffer.append(COMMENT_SEPARATOR);
            buffer.append(content);
        }
        printer.printXMLComment(buffer.toString(), true);
    }

    public void endRender(XHTMLWikiPrinter printer) {
        printer.printXMLComment("stopmacro");
    }
}

