/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.syntax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.rendering.syntax.SyntaxType;

@Component
public class DefaultSyntaxFactory
extends AbstractLogEnabled
implements SyntaxFactory {
    private static final Pattern SYNTAX_PATTERN = Pattern.compile("(.*)\\/(.*)");

    public Syntax createSyntaxFromIdString(String syntaxIdAsString) throws ParseException {
        if (syntaxIdAsString == null) {
            throw new ParseException("The passed Syntax cannot be NULL");
        }
        Matcher matcher = SYNTAX_PATTERN.matcher(syntaxIdAsString);
        if (!matcher.matches()) {
            throw new ParseException("Invalid Syntax format [" + syntaxIdAsString + "]");
        }
        String syntaxId = matcher.group(1);
        String version = matcher.group(2);
        SyntaxType syntaxType = new SyntaxType(syntaxId, syntaxId);
        return new Syntax(syntaxType, version);
    }
}

