/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xwiki.rendering.block.AbstractBlock;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BulletedListBlock;
import org.xwiki.rendering.block.DefinitionDescriptionBlock;
import org.xwiki.rendering.block.DefinitionListBlock;
import org.xwiki.rendering.block.DefinitionTermBlock;
import org.xwiki.rendering.block.EmptyLinesBlock;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.HorizontalLineBlock;
import org.xwiki.rendering.block.IdBlock;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.NewLineBlock;
import org.xwiki.rendering.block.NumberedListBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.QuotationBlock;
import org.xwiki.rendering.block.QuotationLineBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.block.SpecialSymbolBlock;
import org.xwiki.rendering.block.TableBlock;
import org.xwiki.rendering.block.TableCellBlock;
import org.xwiki.rendering.block.TableHeadCellBlock;
import org.xwiki.rendering.block.TableRowBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.syntax.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XDOMGeneratorListener
implements Listener {
    private Stack<Block> stack = new Stack();
    private final MarkerBlock marker = new MarkerBlock();

    public XDOM getXDOM() {
        List<Block> blocks = this.generateListFromStack();
        if (!blocks.isEmpty() && blocks.get(0) instanceof XDOM) {
            return (XDOM)blocks.get(0);
        }
        return new XDOM(blocks);
    }

    private List<Block> generateListFromStack() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        while (!this.stack.empty()) {
            if (this.stack.peek() != this.marker) {
                blocks.add(this.stack.pop());
                continue;
            }
            this.stack.pop();
            break;
        }
        Collections.reverse(blocks);
        return blocks;
    }

    @Override
    public void beginDefinitionDescription() {
        this.stack.push(this.marker);
    }

    @Override
    public void beginDefinitionList(Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginDefinitionTerm() {
        this.stack.push(this.marker);
    }

    @Override
    public void beginDocument(MetaData metaData) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginFormat(Format format, Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginGroup(Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginList(ListType listType, Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginListItem() {
        this.stack.push(this.marker);
    }

    @Override
    public void beginMacroMarker(String name, Map<String, String> macroParameters, String content, boolean isInline) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginParagraph(Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginQuotation(Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginQuotationLine() {
        this.stack.push(this.marker);
    }

    @Override
    public void beginSection(Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginTable(Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginTableCell(Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginTableHeadCell(Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginTableRow(Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.stack.push(this.marker);
    }

    @Override
    public void beginMetaData(MetaData metadata) {
        this.stack.push(this.marker);
    }

    @Override
    public void endDefinitionDescription() {
        this.stack.push(new DefinitionDescriptionBlock(this.generateListFromStack()));
    }

    @Override
    public void endDefinitionList(Map<String, String> parameters) {
        this.stack.push(new DefinitionListBlock(this.generateListFromStack(), parameters));
    }

    @Override
    public void endDefinitionTerm() {
        this.stack.push(new DefinitionTermBlock(this.generateListFromStack()));
    }

    @Override
    public void endDocument(MetaData metaData) {
        this.stack.push(new XDOM(this.generateListFromStack(), metaData));
    }

    @Override
    public void endFormat(Format format, Map<String, String> parameters) {
        this.stack.push(new FormatBlock(this.generateListFromStack(), format, parameters));
    }

    @Override
    public void endGroup(Map<String, String> parameters) {
        this.stack.push(new GroupBlock(this.generateListFromStack(), parameters));
    }

    @Override
    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.stack.push(new HeaderBlock(this.generateListFromStack(), level, parameters, id));
    }

    @Override
    public void endList(ListType listType, Map<String, String> parameters) {
        if (listType == ListType.BULLETED) {
            this.stack.push(new BulletedListBlock(this.generateListFromStack(), parameters));
        } else {
            this.stack.push(new NumberedListBlock(this.generateListFromStack(), parameters));
        }
    }

    @Override
    public void endListItem() {
        this.stack.push(new ListItemBlock(this.generateListFromStack()));
    }

    @Override
    public void endMacroMarker(String name, Map<String, String> macroParameters, String content, boolean isInline) {
        this.stack.push(new MacroMarkerBlock(name, macroParameters, content, this.generateListFromStack(), isInline));
    }

    @Override
    public void endParagraph(Map<String, String> parameters) {
        this.stack.push(new ParagraphBlock(this.generateListFromStack(), parameters));
    }

    @Override
    public void endQuotation(Map<String, String> parameters) {
        this.stack.push(new QuotationBlock(this.generateListFromStack(), parameters));
    }

    @Override
    public void endQuotationLine() {
        this.stack.push(new QuotationLineBlock(this.generateListFromStack()));
    }

    @Override
    public void endSection(Map<String, String> parameters) {
        this.stack.push(new SectionBlock(this.generateListFromStack(), parameters));
    }

    @Override
    public void endTable(Map<String, String> parameters) {
        this.stack.push(new TableBlock(this.generateListFromStack(), parameters));
    }

    @Override
    public void endTableCell(Map<String, String> parameters) {
        this.stack.push(new TableCellBlock(this.generateListFromStack(), parameters));
    }

    @Override
    public void endTableHeadCell(Map<String, String> parameters) {
        this.stack.push(new TableHeadCellBlock(this.generateListFromStack(), parameters));
    }

    @Override
    public void endTableRow(Map<String, String> parameters) {
        this.stack.push(new TableRowBlock(this.generateListFromStack(), parameters));
    }

    @Override
    public void endLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.stack.push(new LinkBlock(this.generateListFromStack(), reference, isFreeStandingURI, parameters));
    }

    @Override
    public void endMetaData(MetaData metadata) {
        this.stack.push(new MetaDataBlock(this.generateListFromStack(), metadata));
    }

    @Override
    public void onEmptyLines(int count) {
        this.stack.push(new EmptyLinesBlock(count));
    }

    @Override
    public void onHorizontalLine(Map<String, String> parameters) {
        this.stack.push(new HorizontalLineBlock(parameters));
    }

    @Override
    public void onId(String name) {
        this.stack.push(new IdBlock(name));
    }

    @Override
    public void onMacro(String id, Map<String, String> macroParameters, String content, boolean isInline) {
        this.stack.push(new MacroBlock(id, macroParameters, content, isInline));
    }

    @Override
    public void onNewLine() {
        this.stack.push(new NewLineBlock());
    }

    @Override
    public void onRawText(String rawContent, Syntax syntax) {
        this.stack.push(new RawBlock(rawContent, syntax));
    }

    @Override
    public void onSpace() {
        this.stack.push(new SpaceBlock());
    }

    @Override
    public void onSpecialSymbol(char symbol) {
        this.stack.push(new SpecialSymbolBlock(symbol));
    }

    @Override
    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        this.stack.push(new VerbatimBlock(protectedString, parameters, isInline));
    }

    @Override
    public void onWord(String word) {
        this.stack.push(new WordBlock(word));
    }

    @Override
    public void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.stack.push(new ImageBlock(reference, isFreeStandingURI, parameters));
    }

    private static class MarkerBlock
    extends AbstractBlock {
        private MarkerBlock() {
        }

        public void traverse(Listener listener) {
        }
    }
}

