/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Named(value="plain/1.0")
@Singleton
public class PlainTextStreamParser
implements StreamParser {
    public static final Pattern SPECIALSYMBOL_PATTERN = Pattern.compile("[!\"#$%&'()*+,-./:;<=>?@\\[\\]^_`{|}~]");

    public Syntax getSyntax() {
        return Syntax.PLAIN_1_0;
    }

    private int readChar(Reader source) throws ParseException {
        int c;
        try {
            c = source.read();
        }
        catch (IOException e) {
            throw new ParseException("Failed to read input source", e);
        }
        return c;
    }

    public void parse(Reader source, Listener listener) throws ParseException {
        int charAsInt;
        StringBuffer word = new StringBuffer();
        BufferedReader bufferedSource = new BufferedReader(source);
        listener.beginDocument(MetaData.EMPTY);
        listener.beginParagraph(Listener.EMPTY_PARAMETERS);
        while ((charAsInt = this.readChar(bufferedSource)) != -1) {
            char c = (char)charAsInt;
            if (c == '\n') {
                if (word.length() > 0) {
                    listener.onWord(word.toString());
                }
                listener.onNewLine();
                word.setLength(0);
                continue;
            }
            if (c == '\r') continue;
            if (c == ' ') {
                if (word.length() > 0) {
                    listener.onWord(word.toString());
                }
                listener.onSpace();
                word.setLength(0);
                continue;
            }
            if (SPECIALSYMBOL_PATTERN.matcher(String.valueOf(c)).matches()) {
                if (word.length() > 0) {
                    listener.onWord(word.toString());
                }
                listener.onSpecialSymbol(c);
                word.setLength(0);
                continue;
            }
            word.append(c);
        }
        if (word.length() > 0) {
            listener.onWord(word.toString());
        }
        listener.endParagraph(Listener.EMPTY_PARAMETERS);
        listener.endDocument(MetaData.EMPTY);
    }
}

