/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.plain;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.chaining.BlockStateChainingListener;
import org.xwiki.rendering.listener.chaining.EmptyBlockChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.renderer.reference.link.LinkLabelGenerator;

public class PlainTextChainingRenderer
extends AbstractChainingPrintRenderer {
    private static final String NL = "\n";
    private boolean isFirstElementRendered;
    private LinkLabelGenerator linkLabelGenerator;

    public PlainTextChainingRenderer(ListenerChain listenerChain) {
        this(null, listenerChain);
    }

    public PlainTextChainingRenderer(LinkLabelGenerator linkLabelGenerator, ListenerChain listenerChain) {
        this.setListenerChain(listenerChain);
        this.linkLabelGenerator = linkLabelGenerator;
    }

    private BlockStateChainingListener getBlockState() {
        return (BlockStateChainingListener)this.getListenerChain().getListener(BlockStateChainingListener.class);
    }

    protected EmptyBlockChainingListener getEmptyBlockState() {
        return (EmptyBlockChainingListener)this.getListenerChain().getListener(EmptyBlockChainingListener.class);
    }

    @Override
    public void beginParagraph(Map<String, String> parameters) {
        this.printEmptyLine();
    }

    @Override
    public void onNewLine() {
        this.getPrinter().print(NL);
    }

    @Override
    public void endLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        if (this.getEmptyBlockState().isCurrentContainerBlockEmpty()) {
            if (reference.getType().equals(ResourceType.DOCUMENT) && this.linkLabelGenerator != null) {
                this.getPrinter().print(this.linkLabelGenerator.generate(reference));
            } else {
                this.getPrinter().print(reference.getReference());
            }
        }
    }

    @Override
    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.printEmptyLine();
    }

    @Override
    public void onWord(String word) {
        this.getPrinter().print(word);
    }

    @Override
    public void beginList(ListType listType, Map<String, String> parameters) {
        if (this.getBlockState().getListDepth() == 1) {
            this.printEmptyLine();
        } else {
            this.getPrinter().print(NL);
        }
    }

    @Override
    public void beginListItem() {
        if (this.getBlockState().getListItemIndex() > 0) {
            this.getPrinter().print(NL);
        }
    }

    @Override
    public void onSpace() {
        this.getPrinter().print(" ");
    }

    @Override
    public void onSpecialSymbol(char symbol) {
        this.getPrinter().print(String.valueOf(symbol));
    }

    @Override
    public void onHorizontalLine(Map<String, String> parameters) {
        this.printEmptyLine();
        this.getPrinter().print("----");
    }

    @Override
    public void onEmptyLines(int count) {
        this.getPrinter().print(StringUtils.repeat((String)NL, (int)count));
    }

    @Override
    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        this.getPrinter().print(protectedString);
    }

    @Override
    public void beginDefinitionList(Map<String, String> parameters) {
        if (this.getBlockState().getDefinitionListDepth() == 1 && !this.getBlockState().isInList()) {
            this.printEmptyLine();
        } else {
            this.getPrinter().print(NL);
        }
    }

    @Override
    public void beginDefinitionTerm() {
        if (this.getBlockState().getDefinitionListItemIndex() > 0) {
            this.getPrinter().print(NL);
        }
    }

    @Override
    public void beginDefinitionDescription() {
        if (this.getBlockState().getDefinitionListItemIndex() > 0) {
            this.getPrinter().print(NL);
        }
    }

    @Override
    public void beginQuotationLine() {
        if (this.getBlockState().getQuotationLineIndex() > 0) {
            this.getPrinter().print(NL);
        } else {
            this.printEmptyLine();
        }
    }

    @Override
    public void beginTable(Map<String, String> parameters) {
        this.printEmptyLine();
    }

    @Override
    public void beginTableCell(Map<String, String> parameters) {
        if (this.getBlockState().getCellCol() > 0) {
            this.getPrinter().print("\t");
        }
    }

    @Override
    public void beginTableHeadCell(Map<String, String> parameters) {
        this.beginTableCell(parameters);
    }

    @Override
    public void beginTableRow(Map<String, String> parameters) {
        if (this.getBlockState().getCellRow() > 0) {
            this.getPrinter().print(NL);
        }
    }

    @Override
    public void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
    }

    private void printEmptyLine() {
        if (this.isFirstElementRendered) {
            this.getPrinter().print("\n\n");
        } else {
            this.isFirstElementRendered = true;
        }
    }
}

