/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.renderer.printer;

/**
 * Printer for {@link org.xwiki.rendering.renderer.PrintRenderer}s.
 *
 * @version $Id: 2c3b07db8ac9c85665edb9bcfa1fddbac30230c5 $
 * @since 1.6M1
 */
public interface WikiPrinter
{
    /**
     * @param text print the provided {@link String}.
     */
    void print(String text);

    /**
     * @param text print the provided {@link String} and add a new line.
     */
    void println(String text);
}
