/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.block.AbstractBlock;
import org.xwiki.rendering.listener.Listener;

public class MacroBlock
extends AbstractBlock {
    private String id;
    private String content;
    private boolean inline;

    public MacroBlock(String id, Map<String, String> parameters, boolean isInline) {
        this(id, parameters, null, isInline);
    }

    public MacroBlock(String id, Map<String, String> parameters, String content, boolean isInline) {
        super(parameters);
        this.id = id;
        this.content = content;
        this.inline = isInline;
    }

    public String getId() {
        return this.id;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isInline() {
        return this.inline;
    }

    @Override
    public void traverse(Listener listener) {
        listener.onMacro(this.getId(), this.getParameters(), this.getContent(), this.isInline());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MacroBlock && super.equals(obj)) {
            EqualsBuilder builder = new EqualsBuilder();
            builder.append((Object)this.getContent(), (Object)((MacroBlock)obj).getContent());
            builder.append((Object)this.getId(), (Object)((MacroBlock)obj).getId());
            builder.append(this.isInline(), ((MacroBlock)obj).isInline());
            return builder.isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append((Object)this.getContent());
        builder.append((Object)this.getId());
        builder.append(this.isInline());
        return builder.toHashCode();
    }
}

