/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.transformation.Transformation;

@Component
@Singleton
public class DefaultRenderingConfiguration
implements RenderingConfiguration,
Initializable {
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;
    private List<String> transformationNames = new ArrayList<String>();
    private String linkLabelFormat = "%p";
    private Properties interWikiDefinitions = new Properties();

    public void initialize() throws InitializationException {
        List descriptors = this.componentManager.getComponentDescriptorList(Transformation.class);
        for (ComponentDescriptor descriptor : descriptors) {
            this.transformationNames.add(descriptor.getRoleHint());
        }
    }

    @Override
    public String getLinkLabelFormat() {
        return this.linkLabelFormat;
    }

    public void setLinkLabelFormat(String linkLabelFormat) {
        this.linkLabelFormat = linkLabelFormat;
    }

    @Override
    public Properties getInterWikiDefinitions() {
        return this.interWikiDefinitions;
    }

    public void addInterWikiDefinition(String interWikiAlias, String interWikiURL) {
        this.interWikiDefinitions.setProperty(interWikiAlias, interWikiURL);
    }

    public void setTransformationNames(List<String> transformationNames) {
        this.transformationNames = transformationNames;
    }

    @Override
    public List<String> getTransformationNames() {
        return this.transformationNames;
    }
}

