/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.block;

import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.rendering.block.AbstractBlock;
import org.xwiki.rendering.listener.Listener;

public class VerbatimBlock
extends AbstractBlock {
    private String protectedString;
    private boolean inline;

    public VerbatimBlock(String protectedString, boolean isInline) {
        this.protectedString = protectedString;
        this.inline = isInline;
    }

    public VerbatimBlock(String protectedString, Map<String, String> parameters, boolean isInline) {
        super(parameters);
        this.protectedString = protectedString;
        this.inline = isInline;
    }

    public String getProtectedString() {
        return this.protectedString;
    }

    public boolean isInline() {
        return this.inline;
    }

    @Override
    public void traverse(Listener listener) {
        listener.onVerbatim(this.getProtectedString(), this.isInline(), this.getParameters());
    }

    public String toString() {
        return this.getProtectedString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof VerbatimBlock && super.equals(obj)) {
            EqualsBuilder builder = new EqualsBuilder();
            builder.append(this.isInline(), ((VerbatimBlock)obj).isInline());
            builder.append((Object)this.getProtectedString(), (Object)((VerbatimBlock)obj).getProtectedString());
            return builder.isEquals();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append(this.isInline());
        builder.append((Object)this.getProtectedString());
        return builder.toHashCode();
    }
}

