/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.ctsreport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.rendering.internal.macro.ctsreport.Result;
import org.xwiki.rendering.internal.macro.ctsreport.State;
import org.xwiki.rendering.internal.macro.ctsreport.Test;

public class ResultExtractor {
    public Set<String> extractByTestName(List<Result> results) {
        TreeSet<String> testNames = new TreeSet<String>();
        for (Result result : results) {
            testNames.add(result.test.prefix);
        }
        return testNames;
    }

    public Map<String, Pair<Set<Test>, Set<Test>>> extractBySyntax(List<Result> results) {
        HashMap<String, Pair<Set<Test>, Set<Test>>> tests = new HashMap<String, Pair<Set<Test>, Set<Test>>>();
        for (Result result : results) {
            Pair inOutTests = (Pair)tests.get(result.syntaxId);
            if (inOutTests == null) {
                inOutTests = new ImmutablePair(new TreeSet(), new TreeSet());
                tests.put(result.syntaxId, (Pair<Set<Test>, Set<Test>>)inOutTests);
            }
            Set typeTests = result.isSyntaxInputTest ? (Set)inOutTests.getLeft() : (Set)inOutTests.getRight();
            typeTests.add(result.test);
        }
        return tests;
    }

    public void normalize(Set<String> testNames, Map<String, Pair<Set<Test>, Set<Test>>> tests) {
        for (Pair<Set<Test>, Set<Test>> inOutTests : tests.values()) {
            this.addNotApplicableTests(testNames, (Set)inOutTests.getLeft());
            this.addNotApplicableTests(testNames, (Set)inOutTests.getRight());
        }
    }

    private void addNotApplicableTests(Set<String> testNames, Set<Test> tests) {
        List<String> inTestNames = this.extractTestNames(tests);
        if (!inTestNames.isEmpty()) {
            for (String testName : testNames) {
                if (inTestNames.contains(testName)) continue;
                Test test = new Test();
                test.prefix = testName;
                test.state = State.NOT_APPLICABLE;
                tests.add(test);
            }
        }
    }

    private List<String> extractTestNames(Set<Test> tests) {
        ArrayList<String> inTestNames = new ArrayList<String>();
        Iterator<Test> it = tests.iterator();
        while (it.hasNext()) {
            inTestNames.add(it.next().prefix);
        }
        return inTestNames;
    }
}

