/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.ctsreport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.rendering.internal.macro.ctsreport.Result;
import org.xwiki.rendering.internal.macro.ctsreport.State;
import org.xwiki.rendering.internal.macro.ctsreport.Test;

public class TestParser {
    private static final Pattern PATTERN = Pattern.compile("(.*) \\[(.*), (.*):(.*), CTS:(.*)\\](.*)");

    public Result parse(String syntaxTest) {
        Result data = new Result();
        Matcher matcher = PATTERN.matcher(syntaxTest);
        if (matcher.matches()) {
            Test test;
            data.syntaxId = matcher.group(2);
            data.isSyntaxInputTest = matcher.group(3).equals("IN");
            data.test = test = new Test();
            test.prefix = matcher.group(1);
            test.syntaxExtension = matcher.group(4);
            test.ctsExtension = matcher.group(5);
            String cause = matcher.group(6);
            test.state = cause.contains("Failing") ? State.FAILING : (cause.contains("Missing") ? State.MISSING : (cause.contains("Passed") ? State.PASSED : State.UNKNOWN));
        } else {
            throw new RuntimeException(String.format("Invalid Syntax Test format for [%s]", syntaxTest));
        }
        return data;
    }
}

