/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.id;

import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.IdBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.id.IdMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="id")
@Singleton
public class IdMacro
extends AbstractMacro<IdMacroParameters> {
    private static final String DESCRIPTION = "Allows putting a reference/location in a page. In HTML for example this is called an Anchor. It allows pointing to that location, for example in links.";

    public IdMacro() {
        super("Id", DESCRIPTION, IdMacroParameters.class);
        this.setPriority(20);
        this.setDefaultCategory("Navigation");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(IdMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        IdBlock idBlock = new IdBlock(parameters.getName());
        return Collections.singletonList(idBlock);
    }
}

