/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.macro.id;

import org.xwiki.properties.annotation.PropertyDescription;
import org.xwiki.properties.annotation.PropertyMandatory;

/**
 * Parameters for the {@link org.xwiki.rendering.internal.macro.id.IdMacro} Macro.
 * 
 * @version $Id: 22f542a7a18ad07605cbd528d8fdd0b2f589f528 $
 * @since 1.6M1
 */
public class IdMacroParameters
{
    /**
     * The identifier string.
     */
    private String name;

    /**
     * @param name the identifier string.
     */
    @PropertyMandatory
    @PropertyDescription("the identifier string")
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return the identifier string.
     */
    public String getName()
    {
        return this.name;
    }
}
