/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSOMObjectImpl;
import com.steadystate.css.dom.CounterImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.RGBColorImpl;
import com.steadystate.css.dom.RectImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.LexicalUnitImpl;
import com.steadystate.css.userdata.UserDataConstants;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSValueImpl
extends CSSOMObjectImpl
implements CSSPrimitiveValue,
CSSValueList,
Serializable {
    private static final long serialVersionUID = 406281136418322579L;
    private Object _value = null;

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public CSSValueImpl(LexicalUnit value, boolean forcePrimitive) {
        Locator locator;
        this._value = !forcePrimitive && value.getNextLexicalUnit() != null ? this.getValues(value) : (value.getParameters() != null ? (value.getLexicalUnitType() == 38 ? new RectImpl(value.getParameters()) : (value.getLexicalUnitType() == 27 ? new RGBColorImpl(value.getParameters()) : (value.getLexicalUnitType() == 25 ? new CounterImpl(false, value.getParameters()) : (value.getLexicalUnitType() == 26 ? new CounterImpl(true, value.getParameters()) : value)))) : value);
        if (value instanceof LexicalUnitImpl && (locator = ((LexicalUnitImpl)value).getLocator()) != null) {
            this.setUserData(UserDataConstants.KEY_LOCATOR, locator);
        }
    }

    public CSSValueImpl() {
    }

    private List<CSSValueImpl> getValues(LexicalUnit value) {
        ArrayList<CSSValueImpl> values = new ArrayList<CSSValueImpl>();
        for (LexicalUnit lu = value; lu != null; lu = lu.getNextLexicalUnit()) {
            if (lu.getLexicalUnitType() == 0 || lu.getLexicalUnitType() == 4) continue;
            values.add(new CSSValueImpl(lu, true));
        }
        return values;
    }

    public CSSValueImpl(LexicalUnit value) {
        this(value, false);
    }

    @Override
    public String getCssText() {
        if (this.getCssValueType() == 2) {
            StringBuilder sb = new StringBuilder();
            List list = (List)this._value;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof LexicalUnit) {
                    LexicalUnit lu = (LexicalUnit)((CSSValueImpl)list.get((int)0))._value;
                    while (lu != null) {
                        sb.append(lu.toString());
                        LexicalUnit prev = lu;
                        if ((lu = lu.getNextLexicalUnit()) == null || lu.getLexicalUnitType() == 0 || lu.getLexicalUnitType() == 4 || prev.getLexicalUnitType() == 4) continue;
                        sb.append(" ");
                    }
                } else {
                    sb.append(o);
                }
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            return sb.toString();
        }
        return this._value.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSValueImpl v2 = (CSSValueImpl)parser.parsePropertyValue(is);
            this._value = v2._value;
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public short getCssValueType() {
        if (this._value instanceof List) {
            return 2;
        }
        if (this._value instanceof LexicalUnit && ((LexicalUnit)this._value).getLexicalUnitType() == 12) {
            return 0;
        }
        return 1;
    }

    @Override
    public short getPrimitiveType() {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this._value;
            switch (lu.getLexicalUnitType()) {
                case 12: {
                    return 21;
                }
                case 13: 
                case 14: {
                    return 1;
                }
                case 15: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 17: {
                    return 5;
                }
                case 18: {
                    return 8;
                }
                case 19: {
                    return 6;
                }
                case 20: {
                    return 7;
                }
                case 21: {
                    return 9;
                }
                case 22: {
                    return 10;
                }
                case 23: {
                    return 2;
                }
                case 24: {
                    return 20;
                }
                case 28: {
                    return 11;
                }
                case 29: {
                    return 13;
                }
                case 30: {
                    return 12;
                }
                case 31: {
                    return 14;
                }
                case 32: {
                    return 15;
                }
                case 33: {
                    return 17;
                }
                case 34: {
                    return 16;
                }
                case 35: {
                    return 21;
                }
                case 36: {
                    return 19;
                }
                case 37: {
                    return 22;
                }
                case 39: 
                case 40: 
                case 41: {
                    return 19;
                }
                case 42: {
                    return 18;
                }
            }
        } else {
            if (this._value instanceof RectImpl) {
                return 24;
            }
            if (this._value instanceof RGBColorImpl) {
                return 25;
            }
            if (this._value instanceof CounterImpl) {
                return 23;
            }
        }
        return 0;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        this._value = LexicalUnitImpl.createNumber(null, floatValue);
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this._value;
            return lu.getFloatValue();
        }
        throw new DOMExceptionImpl(15, 10);
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        switch (stringType) {
            case 19: {
                this._value = LexicalUnitImpl.createString(null, stringValue);
                break;
            }
            case 20: {
                this._value = LexicalUnitImpl.createURI(null, stringValue);
                break;
            }
            case 21: {
                this._value = LexicalUnitImpl.createIdent(null, stringValue);
                break;
            }
            case 22: {
                throw new DOMExceptionImpl(9, 19);
            }
            default: {
                throw new DOMExceptionImpl(15, 11);
            }
        }
    }

    @Override
    public String getStringValue() throws DOMException {
        if (this._value instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this._value;
            if (lu.getLexicalUnitType() == 35 || lu.getLexicalUnitType() == 36 || lu.getLexicalUnitType() == 24 || lu.getLexicalUnitType() == 12) {
                return lu.getStringValue();
            }
            if (lu.getLexicalUnitType() == 37) {
                return lu.getParameters().getStringValue();
            }
        } else if (this._value instanceof List) {
            return null;
        }
        throw new DOMExceptionImpl(15, 11);
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        if (!(this._value instanceof Counter)) {
            throw new DOMExceptionImpl(15, 12);
        }
        return (Counter)this._value;
    }

    @Override
    public Rect getRectValue() throws DOMException {
        if (!(this._value instanceof Rect)) {
            throw new DOMExceptionImpl(15, 13);
        }
        return (Rect)this._value;
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        if (!(this._value instanceof RGBColor)) {
            throw new DOMExceptionImpl(15, 14);
        }
        return (RGBColor)this._value;
    }

    @Override
    public int getLength() {
        return this._value instanceof List ? ((List)this._value).size() : 0;
    }

    @Override
    public CSSValue item(int index) {
        return this._value instanceof List ? (CSSValue)((List)this._value).get(index) : null;
    }

    public String toString() {
        return this.getCssText();
    }
}

