/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.embed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.internal.Composable;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.logging.DefaultLogger;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentManagerInitializer;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.LogEnabled;
import org.xwiki.component.util.ReflectionUtils;

public class EmbeddableComponentManager
implements ComponentManager {
    private ComponentEventManager eventManager;
    private ComponentManager parent;
    private Map<RoleHint<?>, ComponentDescriptor<?>> descriptors = new HashMap();
    private Map<RoleHint<?>, Object> components = new ConcurrentHashMap();
    private Logger logger = LoggerFactory.getLogger(EmbeddableComponentManager.class);

    public void initialize(ClassLoader classLoader) {
        ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
        loader.initialize(this, classLoader);
        try {
            List<ComponentManagerInitializer> initializers = this.lookupList(ComponentManagerInitializer.class);
            for (ComponentManagerInitializer initializer : initializers) {
                initializer.initialize(this);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup ComponentManagerInitializer components", e);
        }
    }

    @Override
    public <T> boolean hasComponent(Class<T> role, String roleHint) {
        return this.descriptors.containsKey(new RoleHint<T>(role, roleHint));
    }

    @Override
    public <T> boolean hasComponent(Class<T> role) {
        return this.descriptors.containsKey(new RoleHint<T>(role));
    }

    @Override
    public <T> T lookup(Class<T> role) throws ComponentLookupException {
        return this.initialize(new RoleHint<T>(role));
    }

    @Override
    public <T> T lookup(Class<T> role, String roleHint) throws ComponentLookupException {
        return this.initialize(new RoleHint<T>(role, roleHint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<T> lookupList(Class<T> role) throws ComponentLookupException {
        ArrayList<Object> objects = new ArrayList<Object>();
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            for (RoleHint<?> roleHint : this.descriptors.keySet()) {
                if (!roleHint.getRole().getName().equals(role.getName())) continue;
                objects.add(this.initialize(roleHint));
            }
            if (this.getParent() != null) {
                objects.addAll(this.getParent().lookupList(role));
            }
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> lookupMap(Class<T> role) throws ComponentLookupException {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            for (RoleHint<?> roleHint : this.descriptors.keySet()) {
                if (!roleHint.getRole().getName().equals(role.getName())) continue;
                objects.put(roleHint.getHint(), this.initialize(roleHint));
            }
            if (this.getParent() != null) {
                for (Map.Entry entry : this.getParent().lookupMap(role).entrySet()) {
                    if (objects.containsKey(entry.getKey())) continue;
                    objects.put((String)entry.getKey(), entry.getValue());
                }
            }
        }
        return objects;
    }

    @Override
    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor) throws ComponentRepositoryException {
        this.registerComponent(componentDescriptor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor, T componentInstance) {
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            RoleHint roleHint = new RoleHint(componentDescriptor.getRole(), componentDescriptor.getRoleHint());
            this.descriptors.put(roleHint, componentDescriptor);
            if (componentInstance != null) {
                this.components.put(roleHint, componentInstance);
            } else {
                this.components.remove(roleHint);
            }
        }
        if (this.eventManager != null) {
            this.eventManager.notifyComponentRegistered(componentDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterComponent(Class<?> role, String roleHint) {
        ComponentDescriptor<?> descriptor;
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            RoleHint roleHintKey = new RoleHint(role, roleHint);
            descriptor = this.descriptors.get(roleHintKey);
            if (descriptor != null) {
                this.descriptors.remove(roleHintKey);
                this.components.remove(roleHintKey);
            }
        }
        if (descriptor != null && this.eventManager != null) {
            this.eventManager.notifyComponentUnregistered(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> role, String roleHint) {
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            return this.descriptors.get(new RoleHint<T>(role, roleHint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> role) {
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            ArrayList<ComponentDescriptor<T>> results = new ArrayList<ComponentDescriptor<T>>();
            for (Map.Entry<RoleHint<?>, ComponentDescriptor<?>> entry : this.descriptors.entrySet()) {
                if (!entry.getKey().getRole().getName().equals(role.getName())) continue;
                results.add(entry.getValue());
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void release(T component) throws ComponentLifecycleException {
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            RoleHint<?> key = null;
            for (Map.Entry<RoleHint<?>, Object> entry : this.components.entrySet()) {
                if (entry.getValue() != component) continue;
                key = entry.getKey();
                break;
            }
            if (key != null) {
                this.components.remove(key);
            }
        }
    }

    @Override
    public ComponentEventManager getComponentEventManager() {
        return this.eventManager;
    }

    @Override
    public void setComponentEventManager(ComponentEventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public ComponentManager getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ComponentManager parentComponentManager) {
        this.parent = parentComponentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T initialize(RoleHint<T> roleHint) throws ComponentLookupException {
        Object instance = this.components.get(roleHint);
        if (instance != null) return (T)instance;
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            instance = this.components.get(roleHint);
            if (instance != null) return (T)instance;
            ComponentDescriptor<?> descriptor = this.descriptors.get(roleHint);
            if (descriptor != null) {
                try {
                    instance = this.createInstance(descriptor);
                    if (instance == null) {
                        throw new ComponentLookupException("Failed to lookup component [" + roleHint + "]");
                    }
                    if (this.descriptors.get(roleHint).getInstantiationStrategy() != ComponentInstantiationStrategy.SINGLETON) return (T)instance;
                    this.components.put(roleHint, instance);
                }
                catch (Exception e) {
                    throw new ComponentLookupException("Failed to lookup component [" + roleHint + "]", e);
                }
            } else {
                ComponentManager parent = this.getParent();
                if (parent == null) throw new ComponentLookupException("Can't find descriptor for the component [" + roleHint + "]");
                instance = this.getParent().lookup(roleHint.getRole(), roleHint.getHint());
            }
            return (T)instance;
        }
    }

    private <T> T createInstance(ComponentDescriptor<T> descriptor) throws Exception {
        T instance = descriptor.getImplementation().newInstance();
        for (ComponentDependency<?> dependency : descriptor.getComponentDependencies()) {
            Object fieldValue = dependency.getMappingType() != null && Logger.class.isAssignableFrom(dependency.getMappingType()) ? LoggerFactory.getLogger(instance.getClass()) : (dependency.getMappingType() != null && List.class.isAssignableFrom(dependency.getMappingType()) ? this.lookupList(dependency.getRole()) : (dependency.getMappingType() != null && Map.class.isAssignableFrom(dependency.getMappingType()) ? this.lookupMap(dependency.getRole()) : this.lookup(dependency.getRole(), dependency.getRoleHint())));
            if (fieldValue == null) continue;
            ReflectionUtils.setFieldValue(instance, dependency.getName(), fieldValue);
        }
        if (LogEnabled.class.isAssignableFrom(descriptor.getImplementation())) {
            ((LogEnabled)instance).enableLogging(new DefaultLogger(instance.getClass()));
        }
        if (ComponentManager.class.isAssignableFrom(descriptor.getImplementation()) && Composable.class.isAssignableFrom(descriptor.getImplementation())) {
            ((Composable)instance).compose(this);
        }
        if (Initializable.class.isAssignableFrom(descriptor.getImplementation())) {
            ((Initializable)instance).initialize();
        }
        return instance;
    }
}

