/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.properties.BeanDescriptor;
import org.xwiki.properties.PropertyDescriptor;
import org.xwiki.properties.annotation.PropertyDescription;
import org.xwiki.properties.annotation.PropertyHidden;
import org.xwiki.properties.annotation.PropertyMandatory;
import org.xwiki.properties.annotation.PropertyName;
import org.xwiki.properties.internal.DefaultPropertyDescriptor;

public class DefaultBeanDescriptor
implements BeanDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBeanDescriptor.class);
    private Class<?> beanClass;
    private Map<String, PropertyDescriptor> parameterDescriptorMap = new LinkedHashMap<String, PropertyDescriptor>();

    public DefaultBeanDescriptor(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.extractBeanDescriptor();
    }

    protected void extractBeanDescriptor() {
        Object defaultInstance = null;
        try {
            defaultInstance = this.getBeanClass().newInstance();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create a new default instance for class " + this.beanClass + ". The BeanDescriptor will not contains any default value information.", e);
        }
        try {
            for (Class<?> currentClass = this.beanClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] fields = currentClass.getFields();
                for (Field field : fields) {
                    this.extractPropertyDescriptor(field, defaultInstance);
                }
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(this.beanClass);
            java.beans.PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null) {
                for (java.beans.PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    if (propertyDescriptor == null) continue;
                    this.extractPropertyDescriptor(propertyDescriptor, defaultInstance);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load bean descriptor for class " + this.beanClass, e);
        }
    }

    protected void extractPropertyDescriptor(java.beans.PropertyDescriptor propertyDescriptor, Object defaultInstance) {
        Method readMethod;
        PropertyHidden parameterHidden;
        DefaultPropertyDescriptor desc = new DefaultPropertyDescriptor();
        desc.setId(propertyDescriptor.getName());
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (writeMethod != null && (parameterHidden = this.extractPropertyAnnotation(writeMethod, readMethod = propertyDescriptor.getReadMethod(), PropertyHidden.class)) == null) {
            desc.setPropertyType(readMethod.getGenericReturnType());
            PropertyName parameterName = this.extractPropertyAnnotation(writeMethod, readMethod, PropertyName.class);
            desc.setName(parameterName != null ? parameterName.value() : propertyDescriptor.getName());
            PropertyDescription parameterDescription = this.extractPropertyAnnotation(writeMethod, readMethod, PropertyDescription.class);
            desc.setDescription(parameterDescription != null ? parameterDescription.value() : propertyDescriptor.getShortDescription());
            PropertyMandatory parameterMandatory = this.extractPropertyAnnotation(writeMethod, readMethod, PropertyMandatory.class);
            desc.setMandatory(parameterMandatory != null);
            if (defaultInstance != null) {
                try {
                    desc.setDefaultValue(readMethod.invoke(defaultInstance, new Object[0]));
                }
                catch (Exception e) {
                    LOGGER.error(MessageFormat.format("Failed to get default property value from getter {0} in class {1}", readMethod.getName(), this.beanClass), e);
                }
            }
            desc.setWriteMethod(writeMethod);
            desc.setReadMethod(readMethod);
            this.parameterDescriptorMap.put(desc.getId(), desc);
        }
    }

    protected void extractPropertyDescriptor(Field field, Object defaultInstance) {
        DefaultPropertyDescriptor desc = new DefaultPropertyDescriptor();
        desc.setId(field.getName());
        PropertyHidden parameterHidden = field.getAnnotation(PropertyHidden.class);
        if (parameterHidden == null) {
            desc.setPropertyType(field.getGenericType());
            PropertyName parameterName = field.getAnnotation(PropertyName.class);
            desc.setName(parameterName != null ? parameterName.value() : field.getName());
            PropertyDescription parameterDescription = field.getAnnotation(PropertyDescription.class);
            desc.setDescription(parameterDescription != null ? parameterDescription.value() : field.getName());
            PropertyMandatory parameterMandatory = field.getAnnotation(PropertyMandatory.class);
            desc.setMandatory(parameterMandatory != null);
            if (defaultInstance != null) {
                try {
                    desc.setDefaultValue(field.get(defaultInstance));
                }
                catch (Exception e) {
                    LOGGER.error(MessageFormat.format("Failed to get default prperty value from field {0} in class {1}", field.getName(), this.beanClass), e);
                }
            }
            desc.setField(field);
            this.parameterDescriptorMap.put(desc.getId(), desc);
        }
    }

    protected <T extends Annotation> T extractPropertyAnnotation(Method writeMethod, Method readMethod, Class<T> annotationClass) {
        T parameterDescription = writeMethod.getAnnotation(annotationClass);
        if (parameterDescription == null && readMethod != null) {
            parameterDescription = readMethod.getAnnotation(annotationClass);
        }
        return parameterDescription;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Collection<PropertyDescriptor> getProperties() {
        return this.parameterDescriptorMap.values();
    }

    @Override
    public PropertyDescriptor getProperty(String propertyName) {
        return this.parameterDescriptorMap.get(propertyName);
    }
}

