/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import org.xwiki.shaded.wikimodel.wem.WikiParameter;
import org.xwiki.shaded.wikimodel.wem.WikiParameters;
import org.xwiki.shaded.wikimodel.wem.WikiReference;
import org.xwiki.shaded.wikimodel.wem.xhtml.handler.ImgTagHandler;
import org.xwiki.shaded.wikimodel.wem.xhtml.impl.XhtmlHandler;

public class XWikiImageTagHandler
extends ImgTagHandler {
    @Override
    public void initialize(XhtmlHandler.TagStack stack) {
        stack.setStackParameter("isInImage", false);
        stack.setStackParameter("isFreeStandingImage", false);
        stack.setStackParameter("imageParameters", WikiParameters.EMPTY);
    }

    @Override
    protected void begin(XhtmlHandler.TagStack.TagContext context) {
        boolean isInImage = (Boolean)context.getTagStack().getStackParameter("isInImage");
        if (isInImage) {
            if (this.isFreeStandingReference(context)) {
                context.getTagStack().setStackParameter("isFreeStandingImage", true);
            } else {
                context.getTagStack().setStackParameter("imageParameters", this.removeMeaningfulParameters(context.getParams()));
            }
        } else {
            super.begin(context);
        }
    }

    @Override
    protected void end(XhtmlHandler.TagStack.TagContext context) {
        WikiParameter src;
        boolean isInImage = (Boolean)context.getTagStack().getStackParameter("isInImage");
        if (!isInImage && (src = context.getParams().getParameter("src")) != null) {
            WikiParameters parameters = context.getParams().remove("src");
            if (this.isFreeStandingReference(context)) {
                context.getScannerContext().onImage(src.getValue());
            } else {
                WikiReference reference = new WikiReference(src.getValue(), null, this.removeMeaningfulParameters(parameters));
                context.getScannerContext().onImage(reference);
            }
        }
    }

    @Override
    protected WikiParameters removeMeaningfulParameters(WikiParameters parameters) {
        boolean isFreeStanding;
        WikiParameter classParam = parameters.getParameter("class");
        boolean bl = isFreeStanding = classParam != null && classParam.getValue().equalsIgnoreCase("wikimodel-freestanding");
        if (isFreeStanding) {
            return this.removeFreestanding(parameters).remove("alt").remove("src");
        }
        return this.removeFreestanding(parameters).remove("src");
    }
}

