/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.shaded.wikimodel.wem.xhtml.filter.XHTMLWhitespaceXMLFilter;
import org.xwiki.shaded.xml.sax.SAXException;
import org.xwiki.shaded.xml.sax.SAXNotRecognizedException;
import org.xwiki.shaded.xml.sax.SAXNotSupportedException;
import org.xwiki.shaded.xml.sax.XMLReader;

public class XWikiXHTMLWhitespaceXMLFilter
extends XHTMLWhitespaceXMLFilter {
    public static final String SAX_CONTAINS_WIKI_SYNTAX_PROPERTY = "http://xwiki.org/sax/properties/contains-wiki-syntax";
    private static final Pattern HTML_WHITESPACE_BOUNDARIES_PATTERN = Pattern.compile("^\\s+|\\s+$");
    private boolean containsWikiSyntax;

    public XWikiXHTMLWhitespaceXMLFilter(XMLReader reader) {
        super(reader);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (SAX_CONTAINS_WIKI_SYNTAX_PROPERTY.equalsIgnoreCase(name)) {
            this.containsWikiSyntax = (Boolean)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.getContent().length() > 0 && this.containsWikiSyntax) {
            this.trimLeadingWhiteSpaces();
            this.trimTrailingWhiteSpaces();
        }
        super.endCDATA();
    }

    @Override
    protected boolean shouldRemoveWhiteSpaces() {
        return this.containsWikiSyntax || super.shouldRemoveWhiteSpaces();
    }

    @Override
    protected void cleanContentExtraWhiteSpaces() {
        if (this.containsWikiSyntax) {
            if (this.getContent().length() > 0) {
                Matcher matcher = HTML_WHITESPACE_BOUNDARIES_PATTERN.matcher(this.getContent());
                String result = matcher.replaceAll(" ");
                this.getContent().setLength(0);
                this.getContent().append(result);
            }
        } else {
            super.cleanContentExtraWhiteSpaces();
        }
    }

    @Override
    protected boolean isSemanticComment(String comment) {
        if (super.isSemanticComment(comment)) {
            return true;
        }
        return comment.startsWith("startwikilink:") || comment.startsWith("stopwikilink") || comment.startsWith("startimage:") || comment.startsWith("stopimage");
    }
}

