/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.javacc.jjtree;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.xwiki.shaded.javacc.jjtree.IO;
import org.xwiki.shaded.javacc.jjtree.JJTreeGlobals;
import org.xwiki.shaded.javacc.jjtree.JJTreeOptions;
import org.xwiki.shaded.javacc.jjtree.NodeFiles;
import org.xwiki.shaded.javacc.parser.OutputFile;

final class JJTreeState {
    private JJTreeState() {
    }

    static void insertParserMembers(IO iO) {
        String string = JJTreeOptions.getStatic() ? "static " : "";
        iO.println();
        iO.println("  protected " + string + JJTreeState.nameState() + " jjtree = new " + JJTreeState.nameState() + "();");
        iO.println();
    }

    private static String nameState() {
        return "JJT" + JJTreeGlobals.parserName + "State";
    }

    static void generateTreeState_java() {
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), JJTreeState.nameState() + ".java");
        try {
            OutputFile outputFile = new OutputFile(file);
            PrintWriter printWriter = outputFile.getPrintWriter();
            NodeFiles.generatePrologue(printWriter);
            JJTreeState.insertState(printWriter);
            outputFile.close();
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    private static void insertState(PrintWriter printWriter) {
        printWriter.println("public class " + JJTreeState.nameState() + " {");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("  private java.util.List nodes;");
        } else {
            printWriter.println("  private java.util.List<Node> nodes;");
        }
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("  private java.util.List marks;");
        } else {
            printWriter.println("  private java.util.List<Integer> marks;");
        }
        printWriter.println("");
        printWriter.println("  private int sp;        // number of nodes on stack");
        printWriter.println("  private int mk;        // current mark");
        printWriter.println("  private boolean node_created;");
        printWriter.println("");
        printWriter.println("  public " + JJTreeState.nameState() + "() {");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("    nodes = new java.util.ArrayList();");
        } else {
            printWriter.println("    nodes = new java.util.ArrayList<Node>();");
        }
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("    marks = new java.util.ArrayList();");
        } else {
            printWriter.println("    marks = new java.util.ArrayList<Integer>();");
        }
        printWriter.println("    sp = 0;");
        printWriter.println("    mk = 0;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Determines whether the current node was actually closed and");
        printWriter.println("     pushed.  This should only be called in the final user action of a");
        printWriter.println("     node scope.  */");
        printWriter.println("  public boolean nodeCreated() {");
        printWriter.println("    return node_created;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Call this to reinitialize the node stack.  It is called");
        printWriter.println("     automatically by the parser's ReInit() method. */");
        printWriter.println("  public void reset() {");
        printWriter.println("    nodes.clear();");
        printWriter.println("    marks.clear();");
        printWriter.println("    sp = 0;");
        printWriter.println("    mk = 0;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Returns the root node of the AST.  It only makes sense to call");
        printWriter.println("     this after a successful parse. */");
        printWriter.println("  public Node rootNode() {");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("    return (Node)nodes.get(0);");
        } else {
            printWriter.println("    return nodes.get(0);");
        }
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Pushes a node on to the stack. */");
        printWriter.println("  public void pushNode(Node n) {");
        printWriter.println("    nodes.add(n);");
        printWriter.println("    ++sp;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Returns the node on the top of the stack, and remove it from the");
        printWriter.println("     stack.  */");
        printWriter.println("  public Node popNode() {");
        printWriter.println("    if (--sp < mk) {");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("      mk = ((Integer)marks.remove(marks.size()-1)).intValue();");
        } else {
            printWriter.println("      mk = marks.remove(marks.size()-1);");
        }
        printWriter.println("    }");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("    return (Node)nodes.remove(nodes.size()-1);");
        } else {
            printWriter.println("    return nodes.remove(nodes.size()-1);");
        }
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Returns the node currently on the top of the stack. */");
        printWriter.println("  public Node peekNode() {");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("    return (Node)nodes.get(nodes.size()-1);");
        } else {
            printWriter.println("    return nodes.get(nodes.size()-1);");
        }
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("  /* Returns the number of children on the stack in the current node");
        printWriter.println("     scope. */");
        printWriter.println("  public int nodeArity() {");
        printWriter.println("    return sp - mk;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("  public void clearNodeScope(Node n) {");
        printWriter.println("    while (sp > mk) {");
        printWriter.println("      popNode();");
        printWriter.println("    }");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("    mk = ((Integer)marks.remove(marks.size()-1)).intValue();");
        } else {
            printWriter.println("    mk = marks.remove(marks.size()-1);");
        }
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("  public void openNodeScope(Node n) {");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("    marks.add(new Integer(mk));");
        } else {
            printWriter.println("    marks.add(mk);");
        }
        printWriter.println("    mk = sp;");
        printWriter.println("    n.jjtOpen();");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("  /* A definite node is constructed from a specified number of");
        printWriter.println("     children.  That number of nodes are popped from the stack and");
        printWriter.println("     made the children of the definite node.  Then the definite node");
        printWriter.println("     is pushed on to the stack. */");
        printWriter.println("  public void closeNodeScope(Node n, int num) {");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("    mk = ((Integer)marks.remove(marks.size()-1)).intValue();");
        } else {
            printWriter.println("    mk = marks.remove(marks.size()-1);");
        }
        printWriter.println("    while (num-- > 0) {");
        printWriter.println("      Node c = popNode();");
        printWriter.println("      c.jjtSetParent(n);");
        printWriter.println("      n.jjtAddChild(c, num);");
        printWriter.println("    }");
        printWriter.println("    n.jjtClose();");
        printWriter.println("    pushNode(n);");
        printWriter.println("    node_created = true;");
        printWriter.println("  }");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("  /* A conditional node is constructed if its condition is true.  All");
        printWriter.println("     the nodes that have been pushed since the node was opened are");
        printWriter.println("     made children of the conditional node, which is then pushed");
        printWriter.println("     on to the stack.  If the condition is false the node is not");
        printWriter.println("     constructed and they are left on the stack. */");
        printWriter.println("  public void closeNodeScope(Node n, boolean condition) {");
        printWriter.println("    if (condition) {");
        printWriter.println("      int a = nodeArity();");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("      mk = ((Integer)marks.remove(marks.size()-1)).intValue();");
        } else {
            printWriter.println("      mk = marks.remove(marks.size()-1);");
        }
        printWriter.println("      while (a-- > 0) {");
        printWriter.println("        Node c = popNode();");
        printWriter.println("        c.jjtSetParent(n);");
        printWriter.println("        n.jjtAddChild(c, a);");
        printWriter.println("      }");
        printWriter.println("      n.jjtClose();");
        printWriter.println("      pushNode(n);");
        printWriter.println("      node_created = true;");
        printWriter.println("    } else {");
        if (!JJTreeOptions.getGenerateGenerics()) {
            printWriter.println("      mk = ((Integer)marks.remove(marks.size()-1)).intValue();");
        } else {
            printWriter.println("      mk = marks.remove(marks.size()-1);");
        }
        printWriter.println("      node_created = false;");
        printWriter.println("    }");
        printWriter.println("  }");
        printWriter.println("}");
    }
}

