/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.javacc.jjtree;

import java.util.Enumeration;
import java.util.Hashtable;
import org.xwiki.shaded.javacc.jjtree.ASTBNFDeclaration;
import org.xwiki.shaded.javacc.jjtree.ASTBNFNodeScope;
import org.xwiki.shaded.javacc.jjtree.ASTBNFNonTerminal;
import org.xwiki.shaded.javacc.jjtree.ASTExpansionNodeScope;
import org.xwiki.shaded.javacc.jjtree.ASTNodeDescriptor;
import org.xwiki.shaded.javacc.jjtree.ASTProduction;
import org.xwiki.shaded.javacc.jjtree.IO;
import org.xwiki.shaded.javacc.jjtree.JJTreeGlobals;
import org.xwiki.shaded.javacc.jjtree.JJTreeNode;
import org.xwiki.shaded.javacc.jjtree.JJTreeOptions;
import org.xwiki.shaded.javacc.jjtree.Node;
import org.xwiki.shaded.javacc.jjtree.NodeFiles;
import org.xwiki.shaded.javacc.jjtree.Token;
import org.xwiki.shaded.javacc.jjtree.TokenUtils;

public class NodeScope {
    private ASTProduction production;
    private ASTNodeDescriptor node_descriptor;
    private String closedVar;
    private String exceptionVar;
    private String nodeVar;
    private int scopeNumber;

    NodeScope(ASTProduction aSTProduction, ASTNodeDescriptor aSTNodeDescriptor) {
        this.production = aSTProduction;
        if (aSTNodeDescriptor == null) {
            String string = this.production.name;
            if (JJTreeOptions.getNodeDefaultVoid()) {
                string = "void";
            }
            this.node_descriptor = ASTNodeDescriptor.indefinite(string);
        } else {
            this.node_descriptor = aSTNodeDescriptor;
        }
        this.scopeNumber = this.production.getNodeScopeNumber(this);
        this.nodeVar = this.constructVariable("n");
        this.closedVar = this.constructVariable("c");
        this.exceptionVar = this.constructVariable("e");
    }

    boolean isVoid() {
        return this.node_descriptor.isVoid();
    }

    ASTNodeDescriptor getNodeDescriptor() {
        return this.node_descriptor;
    }

    String getNodeDescriptorText() {
        return this.node_descriptor.getDescriptor();
    }

    String getNodeVariable() {
        return this.nodeVar;
    }

    private String constructVariable(String string) {
        String string2 = "000" + this.scopeNumber;
        return "jjt" + string + string2.substring(string2.length() - 3, string2.length());
    }

    boolean usesCloseNodeVar() {
        return true;
    }

    void insertOpenNodeDeclaration(IO iO, String string) {
        this.insertOpenNodeCode(iO, string);
    }

    void insertOpenNodeCode(IO iO, String string) {
        String string2;
        String string3 = this.node_descriptor.getNodeType();
        String string4 = JJTreeOptions.getNodeClass().length() > 0 && !JJTreeOptions.getMulti() ? JJTreeOptions.getNodeClass() : string3;
        NodeFiles.ensure(iO, string3);
        iO.print(string + string4 + " " + this.nodeVar + " = ");
        String string5 = JJTreeOptions.getStatic() ? "null" : "this";
        String string6 = string2 = JJTreeOptions.getNodeUsesParser() ? string5 + ", " : "";
        if (JJTreeOptions.getNodeFactory().equals("*")) {
            iO.println("(" + string4 + ")" + string4 + ".jjtCreate(" + string2 + this.node_descriptor.getNodeId() + ");");
        } else if (JJTreeOptions.getNodeFactory().length() > 0) {
            iO.println("(" + string4 + ")" + JJTreeOptions.getNodeFactory() + ".jjtCreate(" + string2 + this.node_descriptor.getNodeId() + ");");
        } else {
            iO.println("new " + string4 + "(" + string2 + this.node_descriptor.getNodeId() + ");");
        }
        if (this.usesCloseNodeVar()) {
            iO.println(string + "boolean " + this.closedVar + " = true;");
        }
        iO.println(string + this.node_descriptor.openNode(this.nodeVar));
        if (JJTreeOptions.getNodeScopeHook()) {
            iO.println(string + "jjtreeOpenNodeScope(" + this.nodeVar + ");");
        }
        if (JJTreeOptions.getTrackTokens()) {
            iO.println(string + this.nodeVar + ".jjtSetFirstToken(getToken(1));");
        }
    }

    void insertCloseNodeCode(IO iO, String string, boolean bl) {
        iO.println(string + this.node_descriptor.closeNode(this.nodeVar));
        if (this.usesCloseNodeVar() && !bl) {
            iO.println(string + this.closedVar + " = false;");
        }
        if (JJTreeOptions.getNodeScopeHook()) {
            iO.println(string + "jjtreeCloseNodeScope(" + this.nodeVar + ");");
        }
        if (JJTreeOptions.getTrackTokens()) {
            iO.println(string + this.nodeVar + ".jjtSetLastToken(getToken(0));");
        }
    }

    void insertOpenNodeAction(IO iO, String string) {
        iO.println(string + "{");
        this.insertOpenNodeCode(iO, string + "  ");
        iO.println(string + "}");
    }

    void insertCloseNodeAction(IO iO, String string) {
        iO.println(string + "{");
        this.insertCloseNodeCode(iO, string + "  ", false);
        iO.println(string + "}");
    }

    private void insertCatchBlocks(IO iO, Enumeration enumeration, String string) {
        if (enumeration.hasMoreElements()) {
            iO.println(string + "} catch (Throwable " + this.exceptionVar + ") {");
            if (this.usesCloseNodeVar()) {
                iO.println(string + "  if (" + this.closedVar + ") {");
                iO.println(string + "    jjtree.clearNodeScope(" + this.nodeVar + ");");
                iO.println(string + "    " + this.closedVar + " = false;");
                iO.println(string + "  } else {");
                iO.println(string + "    jjtree.popNode();");
                iO.println(string + "  }");
            }
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                iO.println(string + "  if (" + this.exceptionVar + " instanceof " + string2 + ") {");
                iO.println(string + "    throw (" + string2 + ")" + this.exceptionVar + ";");
                iO.println(string + "  }");
            }
            iO.println(string + "  throw (Error)" + this.exceptionVar + ";");
        }
    }

    void tryTokenSequence(IO iO, String string, Token token, Token token2) {
        iO.println(string + "try {");
        JJTreeNode.closeJJTreeComment(iO);
        Object object = token;
        while (object != token2.next) {
            TokenUtils.print((Token)object, iO, "jjtThis", this.nodeVar);
            object = ((Token)object).next;
        }
        JJTreeNode.openJJTreeComment(iO, null);
        iO.println();
        object = this.production.throws_list.elements();
        this.insertCatchBlocks(iO, (Enumeration)object, string);
        iO.println(string + "} finally {");
        if (this.usesCloseNodeVar()) {
            iO.println(string + "  if (" + this.closedVar + ") {");
            this.insertCloseNodeCode(iO, string + "    ", true);
            iO.println(string + "  }");
        }
        iO.println(string + "}");
        JJTreeNode.closeJJTreeComment(iO);
    }

    private static void findThrown(Hashtable hashtable, JJTreeNode jJTreeNode) {
        String string;
        JJTreeNode jJTreeNode2;
        if (jJTreeNode instanceof ASTBNFNonTerminal && (jJTreeNode2 = (ASTProduction)JJTreeGlobals.productions.get(string = jJTreeNode.getFirstToken().image)) != null) {
            Enumeration enumeration = jJTreeNode2.throws_list.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                hashtable.put(string2, string2);
            }
        }
        for (int i = 0; i < jJTreeNode.jjtGetNumChildren(); ++i) {
            jJTreeNode2 = (JJTreeNode)jJTreeNode.jjtGetChild(i);
            NodeScope.findThrown(hashtable, jJTreeNode2);
        }
    }

    void tryExpansionUnit(IO iO, String string, JJTreeNode jJTreeNode) {
        iO.println(string + "try {");
        JJTreeNode.closeJJTreeComment(iO);
        jJTreeNode.print(iO);
        JJTreeNode.openJJTreeComment(iO, null);
        iO.println();
        Hashtable hashtable = new Hashtable();
        NodeScope.findThrown(hashtable, jJTreeNode);
        Enumeration enumeration = hashtable.elements();
        this.insertCatchBlocks(iO, enumeration, string);
        iO.println(string + "} finally {");
        if (this.usesCloseNodeVar()) {
            iO.println(string + "  if (" + this.closedVar + ") {");
            this.insertCloseNodeCode(iO, string + "    ", true);
            iO.println(string + "  }");
        }
        iO.println(string + "}");
        JJTreeNode.closeJJTreeComment(iO);
    }

    static NodeScope getEnclosingNodeScope(Node node) {
        if (node instanceof ASTBNFDeclaration) {
            return ((ASTBNFDeclaration)node).node_scope;
        }
        for (Node node2 = node.jjtGetParent(); node2 != null; node2 = node2.jjtGetParent()) {
            if (node2 instanceof ASTBNFDeclaration) {
                return ((ASTBNFDeclaration)node2).node_scope;
            }
            if (node2 instanceof ASTBNFNodeScope) {
                return ((ASTBNFNodeScope)node2).node_scope;
            }
            if (!(node2 instanceof ASTExpansionNodeScope)) continue;
            return ((ASTExpansionNodeScope)node2).node_scope;
        }
        return null;
    }
}

