/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal;

import java.lang.reflect.Method;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.shaded.xml.sax.SAXException;
import org.xwiki.shaded.xml.sax.XMLReader;
import org.xwiki.xml.XMLReaderFactory;

@Component
@Singleton
public class DefaultXMLReaderFactory
implements XMLReaderFactory,
Initializable {
    private Object xercesGrammarPool;

    @Override
    public void initialize() throws InitializationException {
        try {
            this.xercesGrammarPool = Class.forName("org.apache.xerces.util.XMLGrammarPoolImpl").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public XMLReader createXMLReader() throws SAXException, ParserConfigurationException {
        XMLReader xmlReader;
        try {
            Object xercesConfiguration = Class.forName("org.apache.xerces.parsers.XML11NonValidatingConfiguration").newInstance();
            Method setPropertyMethod = xercesConfiguration.getClass().getMethod("setProperty", String.class, Object.class);
            setPropertyMethod.invoke(xercesConfiguration, "http://apache.org/xml/properties/internal/grammar-pool", this.xercesGrammarPool);
            xmlReader = (XMLReader)Class.forName("org.apache.xerces.parsers.SAXParser").getConstructor(Class.forName("org.apache.xerces.xni.parser.XMLParserConfiguration")).newInstance(xercesConfiguration);
        }
        catch (Exception e) {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            xmlReader = parser.getXMLReader();
        }
        return xmlReader;
    }
}

