/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.event;

import java.util.Iterator;
import java.util.Map;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.shaded.apache.commons.lang.StringUtils;

public class EventsChainingRenderer
extends AbstractChainingPrintRenderer {
    public EventsChainingRenderer(ListenerChain listenerChain) {
        this.setListenerChain(listenerChain);
    }

    @Override
    public void beginDocument(MetaData metaData) {
        this.getPrinter().println("beginDocument" + this.serializeParameters(metaData.getMetaData()));
    }

    @Override
    public void endDocument(MetaData metaData) {
        this.getPrinter().print("endDocument" + this.serializeParameters(metaData.getMetaData()));
    }

    @Override
    public void beginGroup(Map<String, String> parameters) {
        this.getPrinter().println("beginGroup" + this.serializeParameters(parameters));
    }

    @Override
    public void endGroup(Map<String, String> parameters) {
        this.getPrinter().println("endGroup" + this.serializeParameters(parameters));
    }

    @Override
    public void beginFormat(Format format, Map<String, String> parameters) {
        this.getPrinter().println("beginFormat [" + (Object)((Object)format) + "]" + this.serializeParameters(parameters));
    }

    @Override
    public void endFormat(Format format, Map<String, String> parameters) {
        this.getPrinter().println("endFormat [" + (Object)((Object)format) + "]" + this.serializeParameters(parameters));
    }

    @Override
    public void beginParagraph(Map<String, String> parameters) {
        this.getPrinter().println("beginParagraph" + this.serializeParameters(parameters));
    }

    @Override
    public void endParagraph(Map<String, String> parameters) {
        this.getPrinter().println("endParagraph" + this.serializeParameters(parameters));
    }

    @Override
    public void onNewLine() {
        this.getPrinter().println("onNewLine");
    }

    @Override
    public void beginLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getPrinter().println("beginLink [" + reference + "] [" + isFreeStandingURI + "]" + this.serializeParameters(parameters));
    }

    @Override
    public void endLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getPrinter().println("endLink [" + reference + "] [" + isFreeStandingURI + "]" + this.serializeParameters(parameters));
    }

    @Override
    public void onMacro(String id, Map<String, String> parameters, String content, boolean isInline) {
        this.printMacroData("onMacro", id, parameters, content, isInline);
    }

    @Override
    public void beginSection(Map<String, String> parameters) {
        this.getPrinter().println("beginSection" + this.serializeParameters(parameters));
    }

    @Override
    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.getPrinter().println("beginHeader [" + (Object)((Object)level) + ", " + id + "]" + this.serializeParameters(parameters));
    }

    @Override
    public void endSection(Map<String, String> parameters) {
        this.getPrinter().println("endSection" + this.serializeParameters(parameters));
    }

    @Override
    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.getPrinter().println("endHeader [" + (Object)((Object)level) + ", " + id + "]" + this.serializeParameters(parameters));
    }

    @Override
    public void onWord(String word) {
        this.getPrinter().println("onWord [" + this.getEscaped(word) + "]");
    }

    @Override
    public void beginList(ListType listType, Map<String, String> parameters) {
        this.getPrinter().println("beginList [" + (Object)((Object)listType) + "]" + this.serializeParameters(parameters));
    }

    @Override
    public void beginListItem() {
        this.getPrinter().println("beginListItem");
    }

    @Override
    public void endList(ListType listType, Map<String, String> parameters) {
        this.getPrinter().println("endList [" + (Object)((Object)listType) + "]" + this.serializeParameters(parameters));
    }

    @Override
    public void endListItem() {
        this.getPrinter().println("endListItem");
    }

    @Override
    public void onSpace() {
        this.getPrinter().println("onSpace");
    }

    @Override
    public void onSpecialSymbol(char symbol) {
        this.getPrinter().println("onSpecialSymbol [" + symbol + "]");
    }

    @Override
    public void onRawText(String text, Syntax syntax) {
        this.getPrinter().println("onRawText [" + text + "] [" + syntax.toIdString() + "]");
    }

    @Override
    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.printMacroData("beginMacroMarker", name, parameters, content, isInline);
    }

    @Override
    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.printMacroData("endMacroMarker", name, parameters, content, isInline);
    }

    @Override
    public void beginMetaData(MetaData metaData) {
        this.getPrinter().println("beginMetaData" + this.serializeParameters(metaData.getMetaData()));
    }

    @Override
    public void endMetaData(MetaData metaData) {
        this.getPrinter().println("endMetaData" + this.serializeParameters(metaData.getMetaData()));
    }

    @Override
    public void onId(String name) {
        this.getPrinter().println("onId [" + name + "]");
    }

    @Override
    public void onHorizontalLine(Map<String, String> parameters) {
        this.getPrinter().println("onHorizontalLine" + this.serializeParameters(parameters));
    }

    @Override
    public void onEmptyLines(int count) {
        this.getPrinter().println("onEmptyLines [" + count + "]");
    }

    @Override
    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        this.getPrinter().println("onVerbatim [" + protectedString + "] [" + isInline + "]" + this.serializeParameters(parameters));
    }

    @Override
    public void beginDefinitionList(Map<String, String> parameters) {
        this.getPrinter().println("beginDefinitionList" + this.serializeParameters(parameters));
    }

    @Override
    public void endDefinitionList(Map<String, String> parameters) {
        this.getPrinter().println("endDefinitionList" + this.serializeParameters(parameters));
    }

    @Override
    public void beginDefinitionTerm() {
        this.getPrinter().println("beginDefinitionTerm");
    }

    @Override
    public void beginDefinitionDescription() {
        this.getPrinter().println("beginDefinitionDescription");
    }

    @Override
    public void endDefinitionTerm() {
        this.getPrinter().println("endDefinitionTerm");
    }

    @Override
    public void endDefinitionDescription() {
        this.getPrinter().println("endDefinitionDescription");
    }

    @Override
    public void beginQuotation(Map<String, String> parameters) {
        this.getPrinter().println("beginQuotation" + this.serializeParameters(parameters));
    }

    @Override
    public void endQuotation(Map<String, String> parameters) {
        this.getPrinter().println("endQuotation" + this.serializeParameters(parameters));
    }

    @Override
    public void beginQuotationLine() {
        this.getPrinter().println("beginQuotationLine");
    }

    @Override
    public void endQuotationLine() {
        this.getPrinter().println("endQuotationLine");
    }

    @Override
    public void beginTable(Map<String, String> parameters) {
        this.getPrinter().println("beginTable" + this.serializeParameters(parameters));
    }

    @Override
    public void beginTableCell(Map<String, String> parameters) {
        this.getPrinter().println("beginTableCell" + this.serializeParameters(parameters));
    }

    @Override
    public void beginTableHeadCell(Map<String, String> parameters) {
        this.getPrinter().println("beginTableHeadCell" + this.serializeParameters(parameters));
    }

    @Override
    public void beginTableRow(Map<String, String> parameters) {
        this.getPrinter().println("beginTableRow" + this.serializeParameters(parameters));
    }

    @Override
    public void endTable(Map<String, String> parameters) {
        this.getPrinter().println("endTable" + this.serializeParameters(parameters));
    }

    @Override
    public void endTableCell(Map<String, String> parameters) {
        this.getPrinter().println("endTableCell" + this.serializeParameters(parameters));
    }

    @Override
    public void endTableHeadCell(Map<String, String> parameters) {
        this.getPrinter().println("endTableHeadCell" + this.serializeParameters(parameters));
    }

    @Override
    public void endTableRow(Map<String, String> parameters) {
        this.getPrinter().println("endTableRow" + this.serializeParameters(parameters));
    }

    @Override
    public void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.getPrinter().println("onImage [" + reference + "] [" + isFreeStandingURI + "]" + this.serializeParameters(parameters));
    }

    public String getEscaped(String str) {
        String printableStr;
        if (str == null) {
            printableStr = null;
        } else if (StringUtils.isAsciiPrintable(str)) {
            printableStr = str;
        } else {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c > '~') {
                    buffer.append("(((").append((int)c).append(")))");
                    continue;
                }
                buffer.append(c);
            }
            printableStr = buffer.toString();
        }
        return printableStr;
    }

    private void printMacroData(String eventName, String name, Map<String, String> parameters, String content, boolean isInline) {
        StringBuffer parametersBuffer = new StringBuffer();
        Iterator<String> paramsIt = parameters.keySet().iterator();
        while (paramsIt.hasNext()) {
            String paramName = paramsIt.next();
            parametersBuffer.append(paramName).append("=").append(parameters.get(paramName));
            if (!paramsIt.hasNext()) continue;
            parametersBuffer.append("|");
        }
        StringBuffer macroBuffer = new StringBuffer();
        macroBuffer.append(eventName);
        macroBuffer.append(isInline ? "Inline" : "Standalone");
        macroBuffer.append(" [");
        macroBuffer.append(name);
        macroBuffer.append("]");
        macroBuffer.append(" [");
        macroBuffer.append(parametersBuffer);
        macroBuffer.append("]");
        if (content != null) {
            macroBuffer.append(" [");
            macroBuffer.append(content);
            macroBuffer.append("]");
        }
        this.getPrinter().println(macroBuffer.toString());
    }

    private String serializeParameters(Map<String, ? extends Object> parameters) {
        StringBuffer parametersStr = new StringBuffer();
        for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
            String value = entry.getValue().toString();
            String key = entry.getKey();
            if (key == null || value == null) continue;
            parametersStr.append('[').append(this.getEscaped(entry.getKey())).append(']').append('=').append('[').append(this.getEscaped(entry.getValue().toString())).append(']');
        }
        if (parametersStr.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(' ').append('[');
            buffer.append(parametersStr);
            buffer.append(']');
            return buffer.toString();
        }
        return "";
    }
}

