/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.properties.BeanManager;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.descriptor.AbstractMacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultMacroDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.shaded.apache.commons.lang.StringUtils;

public abstract class AbstractMacro<P>
implements Macro<P>,
Initializable {
    public static final String DEFAULT_CATEGORY_FORMATTING = "Formatting";
    public static final String DEFAULT_CATEGORY_DEVELOPMENT = "Development";
    public static final String DEFAULT_CATEGORY_CONTENT = "Content";
    public static final String DEFAULT_CATEGORY_NAVIGATION = "Navigation";
    @Inject
    protected BeanManager beanManager;
    private String name;
    private String description;
    private ContentDescriptor contentDescriptor;
    private Class<?> parametersBeanClass;
    private MacroDescriptor macroDescriptor;
    private int priority = 1000;
    private String defaultCategory;

    public AbstractMacro(String name) {
        this(name, null);
    }

    public AbstractMacro(String name, String description) {
        this(name, description, null, Object.class);
    }

    public AbstractMacro(String name, String description, ContentDescriptor contentDescriptor) {
        this(name, description, contentDescriptor, Object.class);
    }

    public AbstractMacro(String name, String description, Class<?> parametersBeanClass) {
        this(name, description, null, parametersBeanClass);
    }

    public AbstractMacro(String name, String description, ContentDescriptor contentDescriptor, Class<?> parametersBeanClass) {
        this.name = name;
        this.description = description;
        this.contentDescriptor = contentDescriptor;
        this.parametersBeanClass = parametersBeanClass;
    }

    @Override
    public void initialize() throws InitializationException {
        MacroId macroId = null;
        String hint = this.extractMacroComponentHint();
        if (hint != null && !"default".equals(hint) && !"".equals(hint)) {
            macroId = new MacroId(hint);
        }
        DefaultMacroDescriptor descriptor = new DefaultMacroDescriptor(macroId, this.name, this.description, this.contentDescriptor, this.beanManager.getBeanDescriptor(this.parametersBeanClass));
        descriptor.setDefaultCategory(this.defaultCategory);
        this.setDescriptor(descriptor);
    }

    private String extractMacroComponentHint() {
        String hint = null;
        Named named = this.getClass().getAnnotation(Named.class);
        if (named != null) {
            hint = named.value();
        } else {
            Component component = this.getClass().getAnnotation(Component.class);
            if (component != null && component.hints().length > 0) {
                hint = component.hints()[0];
            } else if (component != null && StringUtils.isNotBlank(component.value())) {
                hint = component.value().trim();
            }
        }
        return hint;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public MacroDescriptor getDescriptor() {
        return this.macroDescriptor;
    }

    @Override
    public int compareTo(Macro<?> macro) {
        return this.getPriority() - macro.getPriority();
    }

    protected void setDescriptor(MacroDescriptor descriptor) {
        this.macroDescriptor = descriptor;
    }

    protected void setDefaultCategory(String defaultCategory) {
        this.defaultCategory = defaultCategory;
        if (this.getDescriptor() instanceof AbstractMacroDescriptor) {
            ((AbstractMacroDescriptor)this.getDescriptor()).setDefaultCategory(defaultCategory);
        }
    }
}

