/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml;

import java.io.StringWriter;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;
import org.xwiki.xml.ExtractHandler;

public final class XMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XMLUtils.class);
    private static final String AMP = "&#38;";
    private static final Pattern AMP_PATTERN = Pattern.compile("&(?:amp|#0*+38|#x0*+26);");
    private static final String APOS = "&#39;";
    private static final Pattern APOS_PATTERN = Pattern.compile("&(?:apos|#0*+39|#x0*+27);");
    private static final String QUOT = "&#34;";
    private static final Pattern QUOT_PATTERN = Pattern.compile("&(?:quot|#0*+34|#x0*+22);");
    private static final String LT = "&#60;";
    private static final Pattern LT_PATTERN = Pattern.compile("&(?:lt|#0*+60|#x0*+3[cC]);");
    private static final String GT = "&#62;";
    private static final Pattern GT_PATTERN = Pattern.compile("&(?:gt|#0*+62|#x0*+3[eE]);");
    private static final DOMImplementationLS LS_IMPL;
    private static final String DISABLE_DTD_PARAM = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    private XMLUtils() {
    }

    public static String extractXML(Node node, int start, int length) {
        ExtractHandler handler = null;
        try {
            handler = new ExtractHandler(start, length);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(new DOMSource(node), new SAXResult(handler));
            return handler.getResult();
        }
        catch (Throwable t) {
            if (handler != null && handler.isFinished()) {
                return handler.getResult();
            }
            throw new RuntimeException("Failed to extract XML", t);
        }
    }

    public static String escapeXMLComment(String content) {
        StringBuffer str = new StringBuffer(content.length());
        char[] buff = content.toCharArray();
        int lastChar = 0;
        for (int n : buff) {
            if (n == 92) {
                str.append('\\');
            } else if (n == 45 && lastChar == 45) {
                str.append('\\');
            }
            str.append((char)n);
            lastChar = n;
        }
        if (lastChar == 45) {
            str.append('\\');
        }
        return str.toString();
    }

    public static String unescapeXMLComment(String content) {
        StringBuffer str = new StringBuffer(content.length());
        char[] buff = content.toCharArray();
        boolean escaped = false;
        for (char c : buff) {
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            str.append(c);
            escaped = false;
        }
        return str.toString();
    }

    public static String escape(Object content) {
        return XMLUtils.escapeAttributeValue(content);
    }

    public static String escapeAttributeValue(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        StringBuilder result = new StringBuilder((int)((double)str.length() * 1.1));
        int length = str.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    result.append(AMP);
                    continue block7;
                }
                case '\'': {
                    result.append(APOS);
                    continue block7;
                }
                case '\"': {
                    result.append(QUOT);
                    continue block7;
                }
                case '<': {
                    result.append(LT);
                    continue block7;
                }
                case '>': {
                    result.append(GT);
                    continue block7;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String escapeElementContent(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        StringBuilder result = new StringBuilder((int)((double)str.length() * 1.1));
        int length = str.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    result.append(AMP);
                    continue block5;
                }
                case '<': {
                    result.append(LT);
                    continue block5;
                }
                case '>': {
                    result.append(GT);
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String unescape(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        str = APOS_PATTERN.matcher(str).replaceAll("'");
        str = QUOT_PATTERN.matcher(str).replaceAll("\"");
        str = LT_PATTERN.matcher(str).replaceAll("<");
        str = GT_PATTERN.matcher(str).replaceAll(">");
        str = AMP_PATTERN.matcher(str).replaceAll("&");
        return str;
    }

    public static Document createDOMDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            LOG.error("Cannot create DOM Documents", ex);
            return null;
        }
    }

    public static Document parse(LSInput source) {
        try {
            LSParser p = LS_IMPL.createLSParser((short)1, null);
            p.getDomConfig().setParameter("validate", false);
            if (p.getDomConfig().canSetParameter(DISABLE_DTD_PARAM, false)) {
                p.getDomConfig().setParameter(DISABLE_DTD_PARAM, false);
            }
            return p.parse(source);
        }
        catch (Exception ex) {
            LOG.warn("Cannot parse XML document: {}", (Object)ex.getMessage());
            return null;
        }
    }

    public static String serialize(Node node) {
        return XMLUtils.serialize(node, true);
    }

    public static String serialize(Node node, boolean withXmlDeclaration) {
        if (node == null) {
            return "";
        }
        try {
            LSOutput output = LS_IMPL.createLSOutput();
            StringWriter result = new StringWriter();
            output.setCharacterStream(result);
            LSSerializer serializer = LS_IMPL.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", withXmlDeclaration);
            serializer.setNewLine("\n");
            String encoding = "UTF-8";
            if (node instanceof Document) {
                encoding = ((Document)node).getXmlEncoding();
            } else if (node.getOwnerDocument() != null) {
                encoding = node.getOwnerDocument().getXmlEncoding();
            }
            output.setEncoding(encoding);
            serializer.write(node, output);
            return result.toString();
        }
        catch (Exception ex) {
            LOG.warn("Failed to serialize node to XML String: {}", (Object)ex.getMessage());
            return "";
        }
    }

    public static String transform(Source xml, Source xslt) {
        if (xml != null && xslt != null) {
            try {
                StringWriter output = new StringWriter();
                StreamResult result = new StreamResult(output);
                TransformerFactory.newInstance().newTransformer(xslt).transform(xml, result);
                return output.toString();
            }
            catch (Exception ex) {
                LOG.warn("Failed to apply XSLT transformation: {}", (Object)ex.getMessage());
            }
        }
        return null;
    }

    static {
        DOMImplementationLS implementation = null;
        try {
            implementation = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS 3.0"));
        }
        catch (Exception ex) {
            LOG.warn("Cannot initialize the XML Script Service: {}", (Object)ex.getMessage());
        }
        LS_IMPL = implementation;
    }
}

