/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.AbstractCSSRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSImportRuleImpl
extends AbstractCSSRuleImpl
implements CSSImportRule,
Serializable {
    private static final long serialVersionUID = 7807829682009179339L;
    String href = null;
    MediaList media = null;

    public void setHref(String href) {
        this.href = href;
    }

    public void setMedia(MediaList media) {
        this.media = media;
    }

    public CSSImportRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, String href, MediaList media) {
        super(parentStyleSheet, parentRule);
        this.href = href;
        this.media = media;
    }

    public CSSImportRuleImpl() {
    }

    public short getType() {
        return 3;
    }

    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        sb.append("@import url(").append(this.getHref()).append(")");
        if (this.getMedia().getLength() > 0) {
            sb.append(" ").append(this.getMedia().toString());
        }
        sb.append(";");
        return sb.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this.parentStyleSheet != null && this.parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 3) {
                throw new DOMExceptionImpl(13, 6);
            }
            this.href = ((CSSImportRuleImpl)r).href;
            this.media = ((CSSImportRuleImpl)r).media;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getHref() {
        return this.href;
    }

    public MediaList getMedia() {
        return this.media;
    }

    public CSSStyleSheet getStyleSheet() {
        return null;
    }

    public String toString() {
        return this.getCssText();
    }
}

