/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.reference;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.InterWikiResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.ResourceReferenceTypeParser;
import org.xwiki.rendering.wiki.WikiModel;
import org.xwiki.shaded.apache.commons.lang3.StringUtils;

@Component
@Named(value="default/link")
@Singleton
public class GenericLinkReferenceParser
implements ResourceReferenceParser {
    public static final String SEPARATOR_INTERWIKI = "@";
    public static final String SEPARATOR_QUERYSTRING = "?";
    public static final String SEPARATOR_ANCHOR = "#";
    public static final char ESCAPE_CHAR = '\\';
    private static final String[] ESCAPES_REFERENCE = new String[]{"\\?", "\\@", "\\#"};
    private static final String[] ESCAPES_EXTRA = new String[]{"\\?", "\\@", "\\#", "\\\\"};
    private static final String[] ESCAPE_INTERWIKI = new String[]{"\\\\", "\\"};
    private static final String[] ESCAPE_REPLACEMENTS_REFERENCE = new String[]{"?", "@", "#"};
    private static final String[] ESCAPE_REPLACEMENTS_EXTRA = new String[]{"?", "@", "#", "\\"};
    private static final String[] ESCAPE_REPLACEMENTS_INTERWIKI = new String[]{"\\", ""};
    private static final List<String> URI_PREFIXES = Arrays.asList("mailto");
    @Inject
    @Named(value="url")
    private ResourceReferenceTypeParser urlResourceReferenceTypeParser;
    @Inject
    private ComponentManager componentManager;

    protected List<String> getAllowedURIPrefixes() {
        return URI_PREFIXES;
    }

    @Override
    public ResourceReference parse(String rawReference) {
        if (!this.isInWikiMode()) {
            ResourceReference resourceReference = new ResourceReference(rawReference, ResourceType.URL);
            resourceReference.setTyped(false);
            return resourceReference;
        }
        ResourceReference resourceReference = this.parseURILinks(rawReference);
        if (resourceReference != null) {
            return resourceReference;
        }
        StringBuffer content = new StringBuffer(rawReference);
        resourceReference = this.parseInterWikiLinks(content);
        if (resourceReference != null) {
            return resourceReference;
        }
        return this.parseDocumentLink(content);
    }

    private ResourceReference parseDocumentLink(StringBuffer content) {
        String queryString = null;
        String text = this.parseElementAfterString(content, SEPARATOR_QUERYSTRING);
        if (text != null) {
            queryString = this.removeEscapesFromExtraParts(text);
        }
        String anchor = null;
        text = this.parseElementAfterString(content, SEPARATOR_ANCHOR);
        if (text != null) {
            anchor = this.removeEscapesFromExtraParts(text);
        }
        DocumentResourceReference reference = new DocumentResourceReference(this.removeEscapesFromReferencePart(content.toString()));
        reference.setTyped(false);
        reference.setQueryString(queryString);
        reference.setAnchor(anchor);
        return reference;
    }

    private ResourceReference parseURILinks(String rawLink) {
        ResourceReference result = null;
        int uriSchemeDelimiterPos = rawLink.indexOf(":");
        if (uriSchemeDelimiterPos > -1) {
            String scheme = rawLink.substring(0, uriSchemeDelimiterPos);
            String reference = rawLink.substring(uriSchemeDelimiterPos + 1);
            if (this.getAllowedURIPrefixes().contains(scheme)) {
                try {
                    ResourceReference resourceReference = this.componentManager.lookup(ResourceReferenceTypeParser.class, scheme).parse(reference);
                    if (resourceReference != null) {
                        result = resourceReference;
                    }
                }
                catch (ComponentLookupException e) {}
            } else {
                ResourceReference resourceReference = this.urlResourceReferenceTypeParser.parse(rawLink);
                if (resourceReference != null) {
                    resourceReference.setTyped(false);
                    result = resourceReference;
                }
            }
        }
        return result;
    }

    private ResourceReference parseInterWikiLinks(StringBuffer content) {
        InterWikiResourceReference result = null;
        String interWikiAlias = this.parseElementAfterString(content, SEPARATOR_INTERWIKI);
        if (interWikiAlias != null) {
            InterWikiResourceReference link = new InterWikiResourceReference(this.removeEscapes(content.toString()));
            link.setInterWikiAlias(this.removeEscapes(interWikiAlias));
            result = link;
        }
        return result;
    }

    protected String parseElementAfterString(StringBuffer content, String separator) {
        String element = null;
        int index = content.lastIndexOf(separator);
        while (index != -1) {
            if (!this.shouldEscape(content, index)) {
                element = content.substring(index + separator.length()).trim();
                content.delete(index, content.length());
                break;
            }
            if (index <= 0) break;
            index = content.lastIndexOf(separator, index - 1);
        }
        return element;
    }

    private boolean isInWikiMode() {
        boolean result = true;
        try {
            this.componentManager.lookup(WikiModel.class);
        }
        catch (ComponentLookupException e) {
            result = false;
        }
        return result;
    }

    private boolean shouldEscape(StringBuffer content, int charPosition) {
        int counter = 0;
        for (int pos = charPosition - 1; pos > -1 && content.charAt(pos) == '\\'; --pos) {
            ++counter;
        }
        return counter % 2 != 0;
    }

    private String removeEscapesFromReferencePart(String text) {
        return StringUtils.replaceEach(text, ESCAPES_REFERENCE, ESCAPE_REPLACEMENTS_REFERENCE);
    }

    private String removeEscapesFromExtraParts(String text) {
        return StringUtils.replaceEach(text, ESCAPES_EXTRA, ESCAPE_REPLACEMENTS_EXTRA);
    }

    private String removeEscapes(String text) {
        return StringUtils.replaceEach(text, ESCAPE_INTERWIKI, ESCAPE_REPLACEMENTS_INTERWIKI);
    }
}

