/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.shaded.wikimodel.wem.xhtml.handler;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS21;
import java.io.StringReader;
import org.w3c.css.sac.InputSource;
import org.xwiki.shaded.wikimodel.wem.WikiParameter;
import org.xwiki.shaded.wikimodel.wem.WikiParameters;
import org.xwiki.shaded.wikimodel.wem.WikiStyle;
import org.xwiki.shaded.wikimodel.wem.xhtml.handler.TagHandler;
import org.xwiki.shaded.wikimodel.wem.xhtml.impl.XhtmlHandler;

public abstract class AbstractFormatTagHandler
extends TagHandler {
    public static final String FORMATWIKISTYLE = "formatWikiStyle";
    public static final String FORMATPARAMETERS = "formatParameters";
    public static final String FORMATSTYLEPARAMETER = "formatStyleParameter";
    private final WikiStyle style;
    private final CSSOMParser cssParser = new CSSOMParser(new SACParserCSS21());

    public AbstractFormatTagHandler() {
        this(null);
    }

    protected AbstractFormatTagHandler(WikiStyle style) {
        super(false, false, true);
        this.style = style;
    }

    protected void begin(XhtmlHandler.TagStack.TagContext context) {
        WikiParameters currentParameters = (WikiParameters)context.getTagStack().getStackParameter(FORMATPARAMETERS);
        CSSStyleDeclarationImpl currentStyle = (CSSStyleDeclarationImpl)context.getTagStack().getStackParameter(FORMATSTYLEPARAMETER);
        if (currentParameters != null) {
            for (WikiParameter parameter : context.getParams()) {
                WikiParameter currentParameter = currentParameters.getParameter(parameter.getKey());
                String value = parameter.getValue();
                if (currentParameter != null) {
                    if (parameter.getKey().equals("style")) {
                        CSSStyleDeclarationImpl mergedStyle = this.mergeStyle(currentStyle, currentParameter.getValue(), parameter.getValue());
                        if (mergedStyle != currentStyle) {
                            value = mergedStyle.getCssText();
                            currentStyle = mergedStyle;
                        }
                    } else if (parameter.getKey().equals("class")) {
                        value = this.mergeClass(currentParameter.getValue(), parameter.getValue());
                    }
                }
                currentParameters = currentParameters.setParameter(parameter.getKey(), value);
            }
        } else {
            currentParameters = new WikiParameters(context.getParams());
        }
        context.getTagStack().pushStackParameter(FORMATPARAMETERS, currentParameters);
        context.getTagStack().pushStackParameter(FORMATSTYLEPARAMETER, currentStyle);
        if (currentParameters.getSize() > 0) {
            context.getScannerContext().beginFormat(currentParameters);
        }
        if (this.style != null) {
            context.getScannerContext().beginFormat(this.style);
            context.getTagStack().pushStackParameter(FORMATWIKISTYLE, this.style);
        }
    }

    private CSSStyleDeclarationImpl mergeStyle(CSSStyleDeclarationImpl parentStyle, String parentStyleValue, String styleValue) {
        CSSStyleDeclarationImpl currentStyle = new CSSStyleDeclarationImpl();
        if (parentStyle == null) {
            try {
                this.cssParser.parseStyleDeclaration(currentStyle, new InputSource(new StringReader(parentStyleValue)));
            }
            catch (Exception e) {
                return parentStyle;
            }
        } else {
            currentStyle.setProperties(parentStyle.getProperties());
        }
        try {
            this.cssParser.parseStyleDeclaration(currentStyle, new InputSource(new StringReader(styleValue)));
        }
        catch (Exception e) {
            return parentStyle;
        }
        return currentStyle;
    }

    private String mergeClass(String value1, String value2) {
        return value1 + " " + value2;
    }

    protected void end(XhtmlHandler.TagStack.TagContext context) {
        if (this.style != null) {
            context.getScannerContext().endFormat(this.style);
            context.getTagStack().popStackParameter(FORMATWIKISTYLE);
        }
        if (context.getParams().getSize() > 0) {
            context.getScannerContext().endFormat(WikiParameters.EMPTY);
        }
        context.getTagStack().popStackParameter(FORMATPARAMETERS);
        context.getTagStack().popStackParameter(FORMATSTYLEPARAMETER);
        WikiStyle currentWikiStyle = (WikiStyle)context.getTagStack().getStackParameter(FORMATWIKISTYLE);
        WikiParameters currentParameters = (WikiParameters)context.getTagStack().getStackParameter(FORMATPARAMETERS);
        if (currentParameters != null && currentParameters.getSize() > 0) {
            context.getScannerContext().beginFormat(currentParameters);
            if (currentWikiStyle != null) {
                context.getScannerContext().beginFormat(currentWikiStyle);
            }
        }
    }
}

