/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml;

import java.util.LinkedHashMap;
import java.util.Map;
import org.xwiki.rendering.internal.renderer.xhtml.XHTMLChainingRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.XHTMLMacroRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.chaining.ListenerChain;

public class AnnotatedXHTMLChainingRenderer
extends XHTMLChainingRenderer {
    private XHTMLMacroRenderer macroRenderer = new XHTMLMacroRenderer();

    public AnnotatedXHTMLChainingRenderer(XHTMLLinkRenderer linkRenderer, XHTMLImageRenderer imageRenderer, ListenerChain listenerChain) {
        super(linkRenderer, imageRenderer, listenerChain);
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean inline) {
        this.macroRenderer.render(this.getXHTMLWikiPrinter(), id, parameters, content);
    }

    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.macroRenderer.beginRender(this.getXHTMLWikiPrinter(), name, parameters, content);
    }

    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.macroRenderer.endRender(this.getXHTMLWikiPrinter());
    }

    private String getMetadataContainerElement() {
        if (this.getBlockState().isInLine()) {
            return "span";
        }
        return "div";
    }

    public void beginMetaData(MetaData metadata) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        for (Map.Entry metadataPair : metadata.getMetaData().entrySet()) {
            attributes.put("data-xwiki-" + (String)metadataPair.getKey(), metadataPair.getValue().toString());
        }
        attributes.put("class", "xwiki-metadata-container");
        this.getXHTMLWikiPrinter().printXMLStartElement(this.getMetadataContainerElement(), attributes);
    }

    public void endMetaData(MetaData metadata) {
        this.getXHTMLWikiPrinter().printXMLEndElement(this.getMetadataContainerElement());
    }
}

