/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.doxia;

import java.util.Map;
import java.util.Stack;
import org.apache.maven.doxia.sink.Sink;
import org.xwiki.rendering.internal.renderer.doxia.DoxiaSinkListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.WrappingListener;

public class DoxiaListener
extends WrappingListener {
    private Stack<Listener> listenerStack = new Stack();
    private Stack<Integer> rowCountStack = new Stack();
    private int tableCount;
    private boolean unstacking;
    private Sink sink;

    public DoxiaListener(Sink sink) {
        this.sink = sink;
        this.pushListener(new DoxiaSinkListener(sink));
    }

    public void beginTable(Map<String, String> parameters) {
        if (this.unstacking) {
            int rowCount = this.rowCountStack.peek();
            int[] justifications = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                justifications[i] = 0;
            }
            super.beginTable(parameters);
            this.sink.tableRows(justifications, true);
        } else {
            if (this.tableCount == 0) {
                this.pushListener((Listener)new QueueListener());
                this.rowCountStack.push(0);
            }
            ++this.tableCount;
            super.beginTable(parameters);
        }
    }

    public void endTable(Map<String, String> parameters) {
        if (!this.unstacking) {
            super.endTable(parameters);
            --this.tableCount;
            if (this.tableCount == 0) {
                QueueListener queueListener = (QueueListener)this.popListener();
                this.unstacking = true;
                queueListener.consumeEvents((Listener)this);
                this.unstacking = false;
            }
        } else {
            this.sink.tableRows_();
            this.rowCountStack.pop();
            super.endTable(parameters);
        }
    }

    public void beginTableRow(Map<String, String> parameters) {
        super.beginTableRow(parameters);
        if (!this.unstacking) {
            int rowCount = this.rowCountStack.pop();
            this.rowCountStack.push(++rowCount);
        }
    }

    private void pushListener(Listener listener) {
        this.listenerStack.push(listener);
        this.setWrappedListener(listener);
    }

    private Listener popListener() {
        Listener listener = this.listenerStack.pop();
        if (!this.listenerStack.empty()) {
            this.setWrappedListener(this.listenerStack.peek());
        }
        return listener;
    }

    private Listener peekListener() {
        return this.listenerStack.peek();
    }
}

