/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.doxia;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.xwiki.rendering.listener.CompositeListener;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.InlineFilterListener;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.VoidListener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;

public class XWikiGeneratorSink
implements Sink {
    private Deque<Listener> listener = new ArrayDeque<Listener>();
    private Deque<Object> parameters = new ArrayDeque<Object>();
    private ResourceReferenceParser linkReferenceParser;
    private IdGenerator idGenerator;
    private PrintRendererFactory plainRendererFactory;
    private StreamParser plainParser;
    private int lineBreaks = 0;
    private int inlineDepth = 0;
    private Syntax syntax;
    private MetaData documentMetadata;
    private boolean isInVerbatim;
    private StringBuffer accumulatedText = new StringBuffer();

    public XWikiGeneratorSink(Listener listener, ResourceReferenceParser linkReferenceParser, PrintRendererFactory plainRendererFactory, IdGenerator idGenerator, StreamParser plainParser, Syntax syntax) {
        this.pushListener(listener);
        this.linkReferenceParser = linkReferenceParser;
        this.idGenerator = idGenerator != null ? idGenerator : new IdGenerator();
        this.plainRendererFactory = plainRendererFactory;
        this.plainParser = plainParser;
        this.syntax = syntax;
        this.documentMetadata = new MetaData();
        this.documentMetadata.addMetaData("syntax", (Object)this.syntax);
    }

    public Listener getListener() {
        return this.listener.peek();
    }

    private Listener pushListener(Listener listener) {
        this.listener.push(listener);
        return listener;
    }

    private Listener popListener() {
        return this.listener.pop();
    }

    private boolean isInline() {
        return this.inlineDepth > 0;
    }

    private void flushEmptyLines() {
        if (this.lineBreaks > 0) {
            if (this.isInline()) {
                for (int i = 0; i < this.lineBreaks; ++i) {
                    this.getListener().onNewLine();
                }
            } else if (this.lineBreaks >= 2) {
                this.getListener().onEmptyLines(this.lineBreaks - 1);
            } else {
                this.getListener().onNewLine();
            }
        }
    }

    public void flush() {
        this.flushEmptyLines();
    }

    public void enableLogging(Log arg0) {
    }

    public void anchor(String name, SinkEventAttributes attributes) {
        this.flushEmptyLines();
        this.getListener().onId(name);
    }

    public void anchor(String name) {
        this.anchor(name, null);
    }

    public void anchor_() {
    }

    public void author(SinkEventAttributes attributes) {
    }

    public void author() {
    }

    public void author_() {
    }

    public void body(SinkEventAttributes attributes) {
        this.body();
    }

    public void body() {
        this.getListener().beginDocument(this.documentMetadata);
    }

    public void body_() {
        this.getListener().endDocument(this.documentMetadata);
    }

    public void bold() {
        this.flushEmptyLines();
        this.getListener().beginFormat(Format.BOLD, Listener.EMPTY_PARAMETERS);
    }

    public void bold_() {
        this.flushEmptyLines();
        this.getListener().endFormat(Format.BOLD, Listener.EMPTY_PARAMETERS);
    }

    public void close() {
    }

    public void comment(String comment) {
    }

    public void date(SinkEventAttributes attributes) {
    }

    public void date() {
    }

    public void date_() {
    }

    public void definedTerm(SinkEventAttributes attributes) {
        this.getListener().beginDefinitionTerm();
        ++this.inlineDepth;
    }

    public void definedTerm() {
        this.definedTerm(null);
    }

    public void definedTerm_() {
        this.flushEmptyLines();
        this.getListener().endDefinitionTerm();
        --this.inlineDepth;
    }

    public void definition(SinkEventAttributes attributes) {
        this.getListener().beginDefinitionDescription();
        ++this.inlineDepth;
    }

    public void definition() {
        this.definition(null);
    }

    public void definition_() {
        this.flushEmptyLines();
        this.getListener().endDefinitionDescription();
        --this.inlineDepth;
    }

    public void definitionList(SinkEventAttributes attributes) {
        this.flushEmptyLines();
        this.getListener().beginDefinitionList(Listener.EMPTY_PARAMETERS);
    }

    public void definitionList() {
        this.definitionList(null);
    }

    public void definitionList_() {
        this.getListener().endDefinitionList(Listener.EMPTY_PARAMETERS);
    }

    public void definitionListItem(SinkEventAttributes attributes) {
    }

    public void definitionListItem() {
    }

    public void definitionListItem_() {
    }

    public void figure(SinkEventAttributes attributes) {
    }

    public void figure() {
    }

    public void figure_() {
    }

    public void figureCaption(SinkEventAttributes attributes) {
    }

    public void figureCaption() {
        this.figureCaption(null);
    }

    public void figureCaption_() {
    }

    public void figureGraphics(String source, SinkEventAttributes attributes) {
        this.flushEmptyLines();
        this.getListener().onImage(new ResourceReference(source, ResourceType.URL), false, Listener.EMPTY_PARAMETERS);
    }

    public void figureGraphics(String source) {
        this.figureGraphics(source, null);
    }

    public void head(SinkEventAttributes sinkEventAttributes) {
        this.head();
    }

    public void head() {
        this.pushListener((Listener)new VoidListener());
    }

    public void head_() {
        this.popListener();
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        this.flushEmptyLines();
        this.getListener().onHorizontalLine(Listener.EMPTY_PARAMETERS);
    }

    public void horizontalRule() {
        this.horizontalRule(null);
    }

    public void italic() {
        this.flushEmptyLines();
        this.getListener().beginFormat(Format.ITALIC, Listener.EMPTY_PARAMETERS);
    }

    public void italic_() {
        this.flushEmptyLines();
        this.getListener().endFormat(Format.ITALIC, Listener.EMPTY_PARAMETERS);
    }

    public void lineBreak(SinkEventAttributes attributes) {
        ++this.lineBreaks;
    }

    public void lineBreak() {
        this.lineBreak(null);
    }

    public void link(String name, SinkEventAttributes attributes) {
        this.flushEmptyLines();
        ResourceReference resourceReference = this.linkReferenceParser.parse(name);
        this.getListener().beginLink(resourceReference, false, Listener.EMPTY_PARAMETERS);
        this.parameters.push(resourceReference);
    }

    public void link(String name) {
        this.link(name, null);
    }

    public void link_() {
        this.flushEmptyLines();
        this.getListener().endLink((ResourceReference)this.parameters.pop(), false, Listener.EMPTY_PARAMETERS);
    }

    public void list(SinkEventAttributes attributes) {
        this.flushEmptyLines();
        this.getListener().beginList(ListType.BULLETED, Listener.EMPTY_PARAMETERS);
    }

    public void list() {
        this.list(null);
    }

    public void list_() {
        this.getListener().endList(ListType.BULLETED, Listener.EMPTY_PARAMETERS);
    }

    public void listItem(SinkEventAttributes attributes) {
        this.getListener().beginListItem();
        ++this.inlineDepth;
    }

    public void listItem() {
        this.listItem(null);
    }

    public void listItem_() {
        this.flushEmptyLines();
        this.getListener().endListItem();
        --this.inlineDepth;
    }

    public void monospaced() {
        this.flushEmptyLines();
        this.getListener().beginFormat(Format.MONOSPACE, Listener.EMPTY_PARAMETERS);
    }

    public void monospaced_() {
        this.flushEmptyLines();
        this.getListener().endFormat(Format.MONOSPACE, Listener.EMPTY_PARAMETERS);
    }

    public void nonBreakingSpace() {
        this.flushEmptyLines();
        this.getListener().onSpace();
    }

    public void numberedList(int numbering, SinkEventAttributes sinkEventAttributes) {
        this.flushEmptyLines();
        this.getListener().beginList(ListType.NUMBERED, Listener.EMPTY_PARAMETERS);
    }

    public void numberedList(int numbering) {
        this.numberedList(numbering, null);
    }

    public void numberedList_() {
        this.getListener().endList(ListType.NUMBERED, Listener.EMPTY_PARAMETERS);
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        this.getListener().beginListItem();
        ++this.inlineDepth;
    }

    public void numberedListItem() {
        this.numberedListItem(null);
    }

    public void numberedListItem_() {
        this.flushEmptyLines();
        this.getListener().endListItem();
        --this.inlineDepth;
    }

    public void pageBreak() {
    }

    public void paragraph(SinkEventAttributes attributes) {
        this.flushEmptyLines();
        this.getListener().beginParagraph(Listener.EMPTY_PARAMETERS);
        ++this.inlineDepth;
    }

    public void paragraph() {
        this.paragraph(null);
    }

    public void paragraph_() {
        this.flushEmptyLines();
        this.getListener().endParagraph(Listener.EMPTY_PARAMETERS);
        --this.inlineDepth;
    }

    public void rawText(String text) {
        this.flushEmptyLines();
        this.getListener().onVerbatim(text, this.isInline(), Listener.EMPTY_PARAMETERS);
    }

    public void section(int level, SinkEventAttributes attributes) {
        this.flushEmptyLines();
        this.getListener().beginSection(Listener.EMPTY_PARAMETERS);
    }

    public void section_(int level) {
        this.flushEmptyLines();
        this.getListener().endSection(Listener.EMPTY_PARAMETERS);
    }

    public void section1() {
        this.section(1, null);
    }

    public void section1_() {
        this.section_(1);
    }

    public void section2() {
        this.section(2, null);
    }

    public void section2_() {
        this.section_(2);
    }

    public void section3() {
        this.section(3, null);
    }

    public void section3_() {
        this.section_(3);
    }

    public void section4() {
        this.section(4, null);
    }

    public void section4_() {
        this.section_(4);
    }

    public void section5() {
        this.section(5, null);
    }

    public void section5_() {
        this.section_(5);
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.flushEmptyLines();
        CompositeListener composite = new CompositeListener();
        composite.addListener((Listener)new QueueListener());
        composite.addListener((Listener)this.plainRendererFactory.createRenderer((WikiPrinter)new DefaultWikiPrinter()));
        this.pushListener((Listener)composite);
        ++this.inlineDepth;
    }

    public void sectionTitle() {
    }

    public void sectionTitle_(int level) {
        this.flushEmptyLines();
        CompositeListener composite = (CompositeListener)this.getListener();
        QueueListener queue = (QueueListener)composite.getListener(0);
        PrintRenderer renderer = (PrintRenderer)composite.getListener(1);
        this.popListener();
        HeaderLevel headerLevel = HeaderLevel.parseInt((int)level);
        String id = this.idGenerator.generateUniqueId("H", renderer.getPrinter().toString());
        this.getListener().beginHeader(headerLevel, id, Listener.EMPTY_PARAMETERS);
        queue.consumeEvents(this.getListener());
        this.getListener().endHeader(headerLevel, id, Listener.EMPTY_PARAMETERS);
        --this.inlineDepth;
    }

    public void sectionTitle_() {
    }

    public void sectionTitle1() {
        this.sectionTitle(1, null);
    }

    public void sectionTitle1_() {
        this.sectionTitle_(1);
    }

    public void sectionTitle2() {
        this.sectionTitle(2, null);
    }

    public void sectionTitle2_() {
        this.sectionTitle_(2);
    }

    public void sectionTitle3() {
        this.sectionTitle(3, null);
    }

    public void sectionTitle3_() {
        this.sectionTitle_(3);
    }

    public void sectionTitle4() {
        this.sectionTitle(4, null);
    }

    public void sectionTitle4_() {
        this.sectionTitle_(4);
    }

    public void sectionTitle5() {
        this.sectionTitle(5, null);
    }

    public void sectionTitle5_() {
        this.sectionTitle_(5);
    }

    public void table(SinkEventAttributes attributes) {
        this.flushEmptyLines();
        this.getListener().beginTable(Listener.EMPTY_PARAMETERS);
    }

    public void table() {
        this.table(null);
    }

    public void table_() {
        this.getListener().endTable(Listener.EMPTY_PARAMETERS);
    }

    public void tableCaption(SinkEventAttributes attributes) {
    }

    public void tableCaption() {
        this.tableCaption(null);
    }

    public void tableCaption_() {
    }

    public void tableCell(SinkEventAttributes attributes) {
        this.getListener().beginTableCell(Listener.EMPTY_PARAMETERS);
        ++this.inlineDepth;
    }

    public void tableCell() {
        this.tableCell((SinkEventAttributes)null);
    }

    public void tableCell(String width) {
        this.tableCell((SinkEventAttributes)null);
    }

    public void tableCell_() {
        this.flushEmptyLines();
        this.getListener().endTableCell(Listener.EMPTY_PARAMETERS);
        --this.inlineDepth;
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.getListener().beginTableHeadCell(Listener.EMPTY_PARAMETERS);
        ++this.inlineDepth;
    }

    public void tableHeaderCell() {
        this.tableHeaderCell((SinkEventAttributes)null);
    }

    public void tableHeaderCell(String width) {
        this.tableHeaderCell((SinkEventAttributes)null);
    }

    public void tableHeaderCell_() {
        this.flushEmptyLines();
        this.getListener().endTableHeadCell(Listener.EMPTY_PARAMETERS);
        --this.inlineDepth;
    }

    public void tableRow(SinkEventAttributes attributes) {
        this.getListener().beginTableRow(Listener.EMPTY_PARAMETERS);
    }

    public void tableRow() {
        this.tableRow(null);
    }

    public void tableRow_() {
        this.getListener().endTableRow(Listener.EMPTY_PARAMETERS);
    }

    public void tableRows(int[] arg0, boolean arg1) {
    }

    public void tableRows_() {
    }

    public void text(String text, SinkEventAttributes attributes) {
        this.flushEmptyLines();
        if (this.isInVerbatim) {
            this.accumulatedText.append(text);
            return;
        }
        InlineFilterListener inlineFilterListener = new InlineFilterListener();
        inlineFilterListener.setWrappedListener(this.getListener());
        try {
            this.plainParser.parse((Reader)new StringReader(text), (Listener)inlineFilterListener);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse raw text [" + text + "]", e);
        }
    }

    public void text(String text) {
        this.text(text, null);
    }

    public void title(SinkEventAttributes attributes) {
    }

    public void title() {
    }

    public void title_() {
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.isInVerbatim = true;
    }

    public void verbatim(boolean boxed) {
        this.isInVerbatim = true;
    }

    public void verbatim_() {
        this.getListener().onVerbatim(this.accumulatedText.toString(), true, Collections.emptyMap());
        this.accumulatedText.setLength(0);
        this.isInVerbatim = false;
    }

    public void unknown(String arg0, Object[] arg1, SinkEventAttributes arg2) {
    }
}

