/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.doxia;

import java.util.Map;
import org.apache.maven.doxia.sink.Sink;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.syntax.Syntax;

public class DoxiaSinkListener
implements Listener {
    private Sink sink;
    private HeaderLevel headerLevel;

    public DoxiaSinkListener(Sink sink) {
        this.sink = sink;
    }

    public void beginDocument(MetaData metadata) {
        this.sink.head();
        this.sink.head_();
        this.sink.body();
    }

    public void endDocument(MetaData metadata) {
        this.sink.body_();
    }

    public void beginGroup(Map<String, String> parameters) {
    }

    public void endGroup(Map<String, String> parameters) {
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        this.sink.verbatim(null);
        this.sink.text(content);
        this.sink.verbatim_();
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.sink.bold();
                break;
            }
            case ITALIC: {
                this.sink.italic();
                break;
            }
            case STRIKEDOUT: {
                break;
            }
            case UNDERLINED: {
                break;
            }
        }
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        switch (format) {
            case BOLD: {
                this.sink.bold_();
                break;
            }
            case ITALIC: {
                this.sink.italic_();
                break;
            }
            case STRIKEDOUT: {
                break;
            }
            case UNDERLINED: {
                break;
            }
        }
    }

    public void beginList(ListType type, Map<String, String> parameters) {
        if (type == ListType.BULLETED) {
            this.sink.list();
        } else {
            this.sink.numberedList(0);
        }
    }

    public void beginListItem() {
        this.sink.listItem();
    }

    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.sink.paragraph();
    }

    public void beginSection(Map<String, String> parameters) {
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        int levelAsInt = level.getAsInt() < 6 ? level.getAsInt() : 5;
        this.sink.section(levelAsInt, null);
        this.sink.sectionTitle(levelAsInt, null);
        this.headerLevel = level;
    }

    public void endList(ListType type, Map<String, String> parameters) {
        if (type == ListType.BULLETED) {
            this.sink.list_();
        } else {
            this.sink.numberedList_();
        }
    }

    public void endListItem() {
        this.sink.listItem_();
    }

    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
    }

    public void endParagraph(Map<String, String> parameters) {
        this.sink.paragraph_();
    }

    public void endSection(Map<String, String> parameters) {
        int levelAsInt = this.headerLevel.getAsInt() < 6 ? this.headerLevel.getAsInt() : 5;
        this.sink.section_(levelAsInt);
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        int levelAsInt = level.getAsInt() < 6 ? level.getAsInt() : 5;
        this.sink.sectionTitle_(levelAsInt);
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean inline) {
    }

    public void onNewLine() {
        this.sink.text("\n");
    }

    public void onSpace() {
        this.sink.text(" ");
    }

    public void onSpecialSymbol(char symbol) {
        this.sink.text("" + symbol);
    }

    public void onWord(String word) {
        this.sink.text(word);
    }

    public void onId(String name) {
    }

    public void onRawText(String text, Syntax syntax) {
        this.sink.rawText(text);
    }

    public void onHorizontalLine(Map<String, String> parameters) {
        this.sink.horizontalRule();
    }

    public void onEmptyLines(int count) {
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        this.sink.definitionList();
    }

    public void endDefinitionList(Map<String, String> parameters) {
        this.sink.definitionList_();
    }

    public void beginDefinitionTerm() {
        this.sink.definedTerm();
    }

    public void beginDefinitionDescription() {
        this.sink.definition();
    }

    public void endDefinitionTerm() {
        this.sink.definedTerm_();
    }

    public void endDefinitionDescription() {
        this.sink.definition_();
    }

    public void beginQuotation(Map<String, String> parameters) {
    }

    public void endQuotation(Map<String, String> parameters) {
    }

    public void beginQuotationLine() {
    }

    public void endQuotationLine() {
    }

    public void beginTable(Map<String, String> parameters) {
        this.sink.table();
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.sink.tableCell();
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        this.sink.tableHeaderCell();
    }

    public void beginTableRow(Map<String, String> parameters) {
        this.sink.tableRow();
    }

    public void endTable(Map<String, String> parameters) {
        this.sink.table_();
    }

    public void endTableCell(Map<String, String> parameters) {
        this.sink.tableCell_();
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.sink.tableHeaderCell_();
    }

    public void endTableRow(Map<String, String> parameters) {
        this.sink.tableRow_();
    }

    public void beginLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.sink.link(reference.getReference());
    }

    public void endLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.sink.link_();
    }

    public void onImage(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.sink.figure();
        this.sink.figureGraphics(reference.getReference());
        this.sink.figure_();
    }

    public void beginMetaData(MetaData metadata) {
    }

    public void endMetaData(MetaData metadata) {
    }
}

