/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.event;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.syntax.Syntax;

public class EventsChainingRenderer
extends AbstractChainingPrintRenderer {
    public EventsChainingRenderer(ListenerChain listenerChain) {
        this.setListenerChain(listenerChain);
    }

    public void beginDocument(MetaData metadata) {
        this.getPrinter().println("beginDocument" + this.serializeParameters(metadata.getMetaData()));
    }

    public void endDocument(MetaData metadata) {
        this.getPrinter().print("endDocument" + this.serializeParameters(metadata.getMetaData()));
    }

    public void beginGroup(Map<String, String> parameters) {
        this.getPrinter().println("beginGroup" + this.serializeParameters(parameters));
    }

    public void endGroup(Map<String, String> parameters) {
        this.getPrinter().println("endGroup" + this.serializeParameters(parameters));
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        this.getPrinter().println("beginFormat [" + format + "]" + this.serializeParameters(parameters));
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        this.getPrinter().println("endFormat [" + format + "]" + this.serializeParameters(parameters));
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.getPrinter().println("beginParagraph" + this.serializeParameters(parameters));
    }

    public void endParagraph(Map<String, String> parameters) {
        this.getPrinter().println("endParagraph" + this.serializeParameters(parameters));
    }

    public void onNewLine() {
        this.getPrinter().println("onNewLine");
    }

    public void beginLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.getPrinter().println("beginLink [" + reference + "] [" + freestanding + "]" + this.serializeParameters(parameters));
    }

    public void endLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.getPrinter().println("endLink [" + reference + "] [" + freestanding + "]" + this.serializeParameters(parameters));
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean inline) {
        this.printMacroData("onMacro", id, parameters, content, inline);
    }

    public void beginSection(Map<String, String> parameters) {
        this.getPrinter().println("beginSection" + this.serializeParameters(parameters));
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.getPrinter().println("beginHeader [" + level + ", " + id + "]" + this.serializeParameters(parameters));
    }

    public void endSection(Map<String, String> parameters) {
        this.getPrinter().println("endSection" + this.serializeParameters(parameters));
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.getPrinter().println("endHeader [" + level + ", " + id + "]" + this.serializeParameters(parameters));
    }

    public void onWord(String word) {
        this.getPrinter().println("onWord [" + this.getEscaped(word) + "]");
    }

    public void beginList(ListType type, Map<String, String> parameters) {
        this.getPrinter().println("beginList [" + type + "]" + this.serializeParameters(parameters));
    }

    public void beginListItem() {
        this.getPrinter().println("beginListItem");
    }

    public void beginListItem(Map<String, String> parameters) {
        this.getPrinter().println("beginListItem" + this.serializeParameters(parameters));
    }

    public void endList(ListType type, Map<String, String> parameters) {
        this.getPrinter().println("endList [" + type + "]" + this.serializeParameters(parameters));
    }

    public void endListItem() {
        this.getPrinter().println("endListItem");
    }

    public void endListItem(Map<String, String> parameters) {
        this.getPrinter().println("endListItem" + this.serializeParameters(parameters));
    }

    public void onSpace() {
        this.getPrinter().println("onSpace");
    }

    public void onSpecialSymbol(char symbol) {
        this.getPrinter().println("onSpecialSymbol [" + this.getEscaped(Character.toString(symbol)) + "]");
    }

    public void onRawText(String text, Syntax syntax) {
        this.getPrinter().println("onRawText [" + text + "] [" + syntax.toIdString() + "]");
    }

    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.printMacroData("beginMacroMarker", name, parameters, content, isInline);
    }

    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.printMacroData("endMacroMarker", name, parameters, content, isInline);
    }

    public void beginMetaData(MetaData metadata) {
        this.getPrinter().println("beginMetaData" + this.serializeParameters(metadata.getMetaData()));
    }

    public void endMetaData(MetaData metadata) {
        this.getPrinter().println("endMetaData" + this.serializeParameters(metadata.getMetaData()));
    }

    public void onId(String name) {
        this.getPrinter().println("onId [" + name + "]");
    }

    public void onHorizontalLine(Map<String, String> parameters) {
        this.getPrinter().println("onHorizontalLine" + this.serializeParameters(parameters));
    }

    public void onEmptyLines(int count) {
        this.getPrinter().println("onEmptyLines [" + count + "]");
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        this.getPrinter().println("onVerbatim [" + content + "] [" + inline + "]" + this.serializeParameters(parameters));
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        this.getPrinter().println("beginDefinitionList" + this.serializeParameters(parameters));
    }

    public void endDefinitionList(Map<String, String> parameters) {
        this.getPrinter().println("endDefinitionList" + this.serializeParameters(parameters));
    }

    public void beginDefinitionTerm() {
        this.getPrinter().println("beginDefinitionTerm");
    }

    public void beginDefinitionDescription() {
        this.getPrinter().println("beginDefinitionDescription");
    }

    public void endDefinitionTerm() {
        this.getPrinter().println("endDefinitionTerm");
    }

    public void endDefinitionDescription() {
        this.getPrinter().println("endDefinitionDescription");
    }

    public void beginQuotation(Map<String, String> parameters) {
        this.getPrinter().println("beginQuotation" + this.serializeParameters(parameters));
    }

    public void endQuotation(Map<String, String> parameters) {
        this.getPrinter().println("endQuotation" + this.serializeParameters(parameters));
    }

    public void beginQuotationLine() {
        this.getPrinter().println("beginQuotationLine");
    }

    public void endQuotationLine() {
        this.getPrinter().println("endQuotationLine");
    }

    public void beginTable(Map<String, String> parameters) {
        this.getPrinter().println("beginTable" + this.serializeParameters(parameters));
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.getPrinter().println("beginTableCell" + this.serializeParameters(parameters));
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        this.getPrinter().println("beginTableHeadCell" + this.serializeParameters(parameters));
    }

    public void beginTableRow(Map<String, String> parameters) {
        this.getPrinter().println("beginTableRow" + this.serializeParameters(parameters));
    }

    public void endTable(Map<String, String> parameters) {
        this.getPrinter().println("endTable" + this.serializeParameters(parameters));
    }

    public void endTableCell(Map<String, String> parameters) {
        this.getPrinter().println("endTableCell" + this.serializeParameters(parameters));
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.getPrinter().println("endTableHeadCell" + this.serializeParameters(parameters));
    }

    public void endTableRow(Map<String, String> parameters) {
        this.getPrinter().println("endTableRow" + this.serializeParameters(parameters));
    }

    public void beginFigure(Map<String, String> parameters) {
        this.getPrinter().println("beginFigure" + this.serializeParameters(parameters));
    }

    public void beginFigureCaption(Map<String, String> parameters) {
        this.getPrinter().println("beginFigureCaption" + this.serializeParameters(parameters));
    }

    public void endFigure(Map<String, String> parameters) {
        this.getPrinter().println("endFigure" + this.serializeParameters(parameters));
    }

    public void endFigureCaption(Map<String, String> parameters) {
        this.getPrinter().println("endFigureCaption" + this.serializeParameters(parameters));
    }

    public void onImage(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        this.getPrinter().println("onImage [" + reference + "] [" + freestanding + "]" + this.serializeParameters(parameters));
    }

    public String getEscaped(String str) {
        String printableStr;
        if (str == null) {
            printableStr = null;
        } else if (StringUtils.isAsciiPrintable((CharSequence)str)) {
            printableStr = str;
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c > '~') {
                    buffer.append("(((").append((int)c).append(")))");
                    continue;
                }
                buffer.append(c);
            }
            printableStr = buffer.toString();
        }
        return printableStr;
    }

    private void printMacroData(String eventName, String name, Map<String, String> parameters, String content, boolean isInline) {
        StringBuilder parametersBuffer = new StringBuilder();
        Iterator<Map.Entry<String, String>> paramsIt = parameters.entrySet().iterator();
        while (paramsIt.hasNext()) {
            Map.Entry<String, String> entry = paramsIt.next();
            parametersBuffer.append(entry.getKey()).append('=').append(entry.getValue());
            if (!paramsIt.hasNext()) continue;
            parametersBuffer.append('|');
        }
        StringBuilder macroBuffer = new StringBuilder();
        macroBuffer.append(eventName);
        macroBuffer.append(isInline ? "Inline" : "Standalone");
        macroBuffer.append(" [");
        macroBuffer.append(name);
        macroBuffer.append(']');
        macroBuffer.append(" [");
        macroBuffer.append((CharSequence)parametersBuffer);
        macroBuffer.append(']');
        if (content != null) {
            macroBuffer.append(" [");
            macroBuffer.append(content);
            macroBuffer.append(']');
        }
        this.getPrinter().println(macroBuffer.toString());
    }

    private String serializeParameters(Map<String, ? extends Object> parameters) {
        TreeMap<String, ? extends Object> sortedParameters = new TreeMap<String, Object>(parameters);
        StringBuilder parametersStr = new StringBuilder();
        for (Map.Entry entry : sortedParameters.entrySet()) {
            String value;
            String string = value = entry.getValue() == null ? null : entry.getValue().toString();
            String key = (String)entry.getKey();
            if (key == null || value == null) continue;
            parametersStr.append('[').append(this.getEscaped((String)entry.getKey())).append(']').append('=').append('[').append(this.getEscaped(entry.getValue().toString())).append(']');
        }
        if (parametersStr.length() > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(' ').append('[');
            buffer.append((CharSequence)parametersStr);
            buffer.append(']');
            return buffer.toString();
        }
        return "";
    }
}

