/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.rendering.html5;

import java.util.HashMap;
import java.util.Map;
import org.xwiki.rendering.internal.renderer.xhtml.XHTMLChainingRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.chaining.ListenerChain;

public class HTML5ChainingRenderer
extends XHTMLChainingRenderer {
    private static final String ELEM_STRONG = "strong";
    private static final String ELEM_EM = "em";
    private static final String ELEM_DEL = "del";
    private static final String ELEM_INS = "ins";
    private static final String ELEM_SUP = "sup";
    private static final String ELEM_SUB = "sub";
    private static final String ELEM_SPAN = "span";

    public HTML5ChainingRenderer(XHTMLLinkRenderer linkRenderer, XHTMLImageRenderer imageRenderer, ListenerChain listenerChain) {
        super(linkRenderer, imageRenderer, listenerChain);
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        if (format == Format.MONOSPACE) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.putAll(parameters);
            attributes.put("class", "monospace");
            this.getXHTMLWikiPrinter().printXMLStartElement(ELEM_SPAN, attributes);
        } else {
            super.beginFormat(format, parameters);
        }
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        if (!parameters.isEmpty()) {
            this.getXHTMLWikiPrinter().printXMLEndElement(ELEM_SPAN);
        }
        if (format == Format.MONOSPACE) {
            this.getXHTMLWikiPrinter().printXMLEndElement(ELEM_SPAN);
        } else {
            super.endFormat(format, new HashMap());
        }
    }
}

